/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.status;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.status.StatusCommand;
import org.netbeans.lib.cvsclient.command.status.StatusInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.file.FileStatus;

public class StatusBuilder
implements Builder {
    private static final String UNKNOWN = ": nothing known about";
    private static final String EXAM_DIR = ": Examining";
    private static final String NOT_IN_REPOSITORY = "No revision control file";
    private static final String FILE = "File: ";
    private static final String STATUS = "Status:";
    private static final String NO_FILE_FILENAME = "no file";
    private static final String WORK_REV = "   Working revision:";
    private static final String REP_REV = "   Repository revision:";
    private static final String TAG = "   Sticky Tag:";
    private static final String DATE = "   Sticky Date:";
    private static final String OPTIONS = "   Sticky Options:";
    private static final String EXISTING_TAGS = "   Existing Tags:";
    private static final String NO_TAGS = "   No Tags Exist";
    private static final String UNKNOWN_FILE = "? ";
    private StatusInformation statusInformation;
    private final EventManager eventManager;
    private final StatusCommand statusCommand;
    private String relativeDirectory;
    private final String localPath;
    private boolean beginning;
    private boolean readingTags;
    private final File[] fileArray;

    public StatusBuilder(EventManager eventManager, StatusCommand statusCommand) {
        this.eventManager = eventManager;
        this.statusCommand = statusCommand;
        File[] fileArray = statusCommand.getFiles();
        if (fileArray != null) {
            this.fileArray = new File[fileArray.length];
            System.arraycopy(fileArray, 0, this.fileArray, 0, fileArray.length);
        } else {
            this.fileArray = null;
        }
        this.localPath = statusCommand.getLocalDirectory();
        this.beginning = true;
    }

    @Override
    public void outputDone() {
        if (this.statusInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.statusInformation));
            this.statusInformation = null;
            this.readingTags = false;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (this.readingTags) {
            if (line.startsWith(NO_TAGS)) {
                this.outputDone();
                return;
            }
            int bracket = line.indexOf("\t(");
            if (bracket > 0) {
                String tag2 = line.substring(0, bracket).trim();
                String rev = line.substring(bracket + 2, line.length() - 1);
                if (this.statusInformation == null) {
                    this.statusInformation = new StatusInformation();
                }
                this.statusInformation.addExistingTag(tag2, rev);
            } else {
                this.outputDone();
                return;
            }
        }
        if (line.startsWith(UNKNOWN_FILE) && this.beginning) {
            File file = new File(this.localPath, line.substring(UNKNOWN_FILE.length()));
            this.statusInformation = new StatusInformation();
            this.statusInformation.setFile(file);
            this.statusInformation.setStatusString(FileStatus.UNKNOWN.toString());
            this.outputDone();
        }
        if (line.startsWith(UNKNOWN)) {
            this.outputDone();
            this.beginning = false;
        } else if (line.indexOf(EXAM_DIR) >= 0) {
            this.relativeDirectory = line.substring(line.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            this.beginning = false;
        } else if (line.startsWith(FILE)) {
            this.outputDone();
            this.statusInformation = new StatusInformation();
            this.processFileAndStatusLine(line.substring(FILE.length()));
            this.beginning = false;
        } else if (line.startsWith(WORK_REV)) {
            this.processWorkRev(line.substring(WORK_REV.length()));
        } else if (line.startsWith(REP_REV)) {
            this.processRepRev(line.substring(REP_REV.length()));
        } else if (line.startsWith(TAG)) {
            this.processTag(line.substring(TAG.length()));
        } else if (line.startsWith(DATE)) {
            this.processDate(line.substring(DATE.length()));
        } else if (line.startsWith(OPTIONS)) {
            this.processOptions(line.substring(OPTIONS.length()));
            if (!this.statusCommand.isIncludeTags()) {
                this.outputDone();
            }
        } else if (line.startsWith(EXISTING_TAGS)) {
            this.readingTags = true;
        }
    }

    private File createFile(String fileName) {
        File file = null;
        if (this.relativeDirectory != null) {
            file = this.relativeDirectory.trim().equals(".") ? new File(this.localPath, fileName) : new File(this.localPath, this.relativeDirectory + '/' + fileName);
        } else if (this.fileArray != null) {
            for (int i = 0; i < this.fileArray.length; ++i) {
                String currentFileName;
                File currentFile = this.fileArray[i];
                if (currentFile == null || currentFile.isDirectory() || !fileName.equals(currentFileName = currentFile.getName())) continue;
                this.fileArray[i] = null;
                file = currentFile;
                break;
            }
        }
        if (file == null) {
            System.err.println("JAVACVS ERROR!! wrong algorithm for assigning path to single files(1)!!");
        }
        return file;
    }

    private void processFileAndStatusLine(String line) {
        int statusIndex = line.lastIndexOf(STATUS);
        String fileName = line.substring(0, statusIndex).trim();
        if (fileName.startsWith(NO_FILE_FILENAME)) {
            fileName = fileName.substring(8);
        }
        this.statusInformation.setFile(this.createFile(fileName));
        String status2 = new String(line.substring(statusIndex + 8).trim());
        this.statusInformation.setStatusString(status2);
    }

    private boolean assertNotNull() {
        if (this.statusInformation == null) {
            System.err.println("Bug: statusInformation must not be null!");
            return false;
        }
        return true;
    }

    private void processWorkRev(String line) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setWorkingRevision(line.trim().intern());
    }

    private void processRepRev(String line) {
        if (!this.assertNotNull()) {
            return;
        }
        if ((line = line.trim()).startsWith(NOT_IN_REPOSITORY)) {
            this.statusInformation.setRepositoryRevision(line.trim().intern());
            return;
        }
        int firstSpace = line.indexOf(9);
        if (firstSpace > 0) {
            this.statusInformation.setRepositoryRevision(line.substring(0, firstSpace).trim().intern());
            this.statusInformation.setRepositoryFileName(new String(line.substring(firstSpace).trim()));
        } else {
            this.statusInformation.setRepositoryRevision("");
            this.statusInformation.setRepositoryFileName("");
        }
    }

    private void processTag(String line) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyTag(line.trim().intern());
    }

    private void processDate(String line) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyDate(line.trim().intern());
    }

    private void processOptions(String line) {
        if (!this.assertNotNull()) {
            return;
        }
        this.statusInformation.setStickyOptions(line.trim().intern());
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }
}

