/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.importcmd;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.command.importcmd.ImportCommand;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class ImportBuilder
implements Builder {
    private static final String NO_CONFLICTS = "No conflicts created by this import";
    private static final String FILE_INFOS = "NUCIL?";
    private final EventManager eventManager;
    private final String localPath;
    private final String module;
    private DefaultFileInfoContainer fileInfoContainer;

    public ImportBuilder(EventManager eventManager, ImportCommand importCommand) {
        this.eventManager = eventManager;
        this.localPath = importCommand.getLocalDirectory();
        this.module = importCommand.getModule();
    }

    @Override
    public void outputDone() {
        if (this.fileInfoContainer == null) {
            return;
        }
        FileInfoEvent event = new FileInfoEvent(this, this.fileInfoContainer);
        this.eventManager.fireCVSEvent(event);
        this.fileInfoContainer = null;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (line.length() > 2 && line.charAt(1) == ' ') {
            String firstChar = line.substring(0, 1);
            if (FILE_INFOS.indexOf(firstChar) >= 0) {
                String filename = line.substring(2).trim();
                this.processFile(firstChar, filename);
            } else {
                this.error(line);
            }
        } else if (line.startsWith(NO_CONFLICTS)) {
            this.outputDone();
        }
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }

    private void error(String line) {
        System.err.println("Don't know anything about: " + line);
    }

    private void processFile(String type, String filename) {
        this.outputDone();
        filename = filename.substring(this.module.length());
        File file = new File(this.localPath, filename);
        this.fileInfoContainer = new DefaultFileInfoContainer();
        this.fileInfoContainer.setType(type);
        this.fileInfoContainer.setFile(file);
        this.outputDone();
    }
}

