/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.history;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Request;
import org.netbeans.lib.cvsclient.request.RootRequest;
import org.netbeans.lib.cvsclient.request.UseUnchangedRequest;

public class HistoryCommand
extends Command {
    private static final long serialVersionUID = 3606230950833982897L;
    private final List<Request> requests = new LinkedList<Request>();
    private boolean forAllUsers;
    private String showBackToRecordContaining;
    private boolean reportCommits;
    private String sinceDate;
    private boolean reportEverything;
    private boolean lastEventOfProject;
    private boolean reportCheckouts;
    private String sinceRevision;
    private boolean reportTags;
    private String sinceTag;
    private boolean forWorkingDirectory;
    private String reportEventType;
    private String timeZone;
    private String[] lastEventForFile;
    private String[] reportOnModule;
    private String[] reportLastEventForModule;
    private String[] forUsers;

    public Builder createBuilder(EventManager eventMan) {
        return null;
    }

    @Override
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.requests.clear();
        super.execute(client, em);
        try {
            if (client.isFirstCommand()) {
                this.requests.add(new RootRequest(client.getRepository()));
                this.requests.add(new UseUnchangedRequest());
            }
            this.addBooleanArgument(this.requests, this.isForAllUsers(), "-a");
            this.addBooleanArgument(this.requests, this.isForWorkingDirectory(), "-w");
            this.addBooleanArgument(this.requests, this.isLastEventOfProject(), "-l");
            this.addBooleanArgument(this.requests, this.isReportCheckouts(), "-o");
            this.addBooleanArgument(this.requests, this.isReportCommits(), "-c");
            this.addBooleanArgument(this.requests, this.isReportEverything(), "-e");
            this.addBooleanArgument(this.requests, this.isReportTags(), "-T");
            this.addStringArgument(this.requests, this.getReportEventType(), "-x");
            this.addStringArgument(this.requests, this.getShowBackToRecordContaining(), "-b");
            this.addStringArgument(this.requests, this.getSinceDate(), "-D");
            this.addStringArgument(this.requests, this.getSinceRevision(), "-r");
            this.addStringArgument(this.requests, this.getSinceTag(), "-t");
            this.addStringArrayArgument(this.requests, this.getForUsers(), "-u");
            this.addStringArrayArgument(this.requests, this.getReportLastEventForModule(), "-n");
            this.addStringArrayArgument(this.requests, this.getReportOnModule(), "-m");
            this.addStringArrayArgument(this.requests, this.getLastEventForFile(), "-f");
            if (!(this.isReportCheckouts() || this.isReportCommits() || this.isReportTags() || this.isReportEverything() || this.getReportEventType() != null || this.getReportOnModule() != null)) {
                this.addBooleanArgument(this.requests, true, "-c");
            }
            if (this.getTimeZone() != null) {
                this.addStringArgument(this.requests, this.getTimeZone(), "-z");
            } else {
                this.addStringArgument(this.requests, "+0000", "-z");
            }
            this.requests.add(CommandRequest.HISTORY);
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    private void addStringArgument(List<Request> reqList, String property, String cvsSwitch) {
        if (property != null) {
            reqList.add(new ArgumentRequest(cvsSwitch));
            reqList.add(new ArgumentRequest(property));
        }
    }

    private void addStringArrayArgument(List<Request> reqList, String[] property, String cvsSwitch) {
        if (property != null) {
            for (String element : property) {
                reqList.add(new ArgumentRequest(cvsSwitch));
                reqList.add(new ArgumentRequest(element));
            }
        }
    }

    private void addBooleanArgument(List<Request> reqList, boolean property, String cvsSwitch) {
        if (property) {
            reqList.add(new ArgumentRequest(cvsSwitch));
        }
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
    }

    @Override
    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("history ");
        toReturn.append(this.getCVSArguments());
        return toReturn.toString();
    }

    @Override
    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'a') {
            this.setForAllUsers(true);
        } else if (opt == 'b') {
            this.setShowBackToRecordContaining(optArg);
        } else if (opt == 'c') {
            this.setReportCommits(true);
        } else if (opt == 'D') {
            this.setSinceDate(optArg);
        } else if (opt == 'e') {
            this.setReportEverything(true);
        } else if (opt == 'l') {
            this.setLastEventOfProject(true);
        } else if (opt == 'o') {
            this.setReportCheckouts(true);
        } else if (opt == 'r') {
            this.setSinceRevision(optArg);
        } else if (opt == 'T') {
            this.setReportTags(true);
        } else if (opt == 't') {
            this.setSinceTag(optArg);
        } else if (opt == 'w') {
            this.setForWorkingDirectory(true);
        } else if (opt == 'x') {
            this.setReportEventType(optArg);
        } else if (opt == 'z') {
            this.setTimeZone(optArg);
        } else if (opt == 'f') {
            this.addLastEventForFile(optArg);
        } else if (opt == 'm') {
            this.addReportOnModule(optArg);
        } else if (opt == 'n') {
            this.addReportLastEventForModule(optArg);
        } else if (opt == 'u') {
            this.addForUsers(optArg);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getOptString() {
        return "ab:cD:ef:lm:n:or:Tt:u:wx:z:";
    }

    @Override
    public void resetCVSCommand() {
        this.setForAllUsers(false);
        this.setForUsers(null);
        this.setForWorkingDirectory(false);
        this.setLastEventForFile(null);
        this.setLastEventOfProject(false);
        this.setReportCheckouts(false);
        this.setReportCommits(false);
        this.setReportEventType(null);
        this.setReportEverything(false);
        this.setReportLastEventForModule(null);
        this.setReportOnModule(null);
        this.setReportTags(false);
        this.setShowBackToRecordContaining(null);
        this.setSinceDate(null);
        this.setSinceRevision(null);
        this.setSinceTag(null);
        this.setTimeZone(null);
    }

    @Override
    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (this.isForAllUsers()) {
            toReturn.append("-a ");
        }
        if (this.isForWorkingDirectory()) {
            toReturn.append("-w ");
        }
        if (this.isLastEventOfProject()) {
            toReturn.append("-l ");
        }
        if (this.isReportCheckouts()) {
            toReturn.append("-o ");
        }
        if (this.isReportCommits()) {
            toReturn.append("-c ");
        }
        if (this.isReportEverything()) {
            toReturn.append("-e ");
        }
        if (this.isReportTags()) {
            toReturn.append("-T ");
        }
        if (this.getForUsers() != null) {
            this.appendArrayToSwitches(toReturn, this.getForUsers(), "-u ");
        }
        if (this.getLastEventForFile() != null) {
            this.appendArrayToSwitches(toReturn, this.getLastEventForFile(), "-f ");
        }
        if (this.getReportEventType() != null) {
            toReturn.append("-x ");
            toReturn.append(this.getReportEventType());
            toReturn.append(" ");
        }
        if (this.getReportLastEventForModule() != null) {
            this.appendArrayToSwitches(toReturn, this.getReportLastEventForModule(), "-n ");
        }
        if (this.getReportOnModule() != null) {
            this.appendArrayToSwitches(toReturn, this.getReportOnModule(), "-m ");
        }
        if (this.getShowBackToRecordContaining() != null) {
            toReturn.append("-b ");
            toReturn.append(this.getShowBackToRecordContaining());
            toReturn.append(" ");
        }
        if (this.getSinceDate() != null) {
            toReturn.append("-D ");
            toReturn.append(this.getSinceDate());
            toReturn.append(" ");
        }
        if (this.getSinceRevision() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getSinceRevision());
            toReturn.append(" ");
        }
        if (this.getSinceTag() != null) {
            toReturn.append("-t ");
            toReturn.append(this.getSinceTag());
            toReturn.append(" ");
        }
        if (this.getTimeZone() != null) {
            toReturn.append("-z ");
            toReturn.append(this.getTimeZone());
            toReturn.append(" ");
        }
        return toReturn.toString();
    }

    private void appendArrayToSwitches(StringBuffer buff, String[] arr, String cvsSwitch) {
        if (arr == null) {
            return;
        }
        for (String element : arr) {
            buff.append(cvsSwitch);
            buff.append(element);
            buff.append(" ");
        }
    }

    public boolean isForAllUsers() {
        return this.forAllUsers;
    }

    public void setForAllUsers(boolean forAllUsers) {
        this.forAllUsers = forAllUsers;
    }

    public String getShowBackToRecordContaining() {
        return this.showBackToRecordContaining;
    }

    public void setShowBackToRecordContaining(String goBackToRecord) {
        this.showBackToRecordContaining = goBackToRecord;
    }

    public boolean isReportCommits() {
        return this.reportCommits;
    }

    public void setReportCommits(boolean reportCommits) {
        this.reportCommits = reportCommits;
    }

    public String getSinceDate() {
        return this.sinceDate;
    }

    public void setSinceDate(String sinceDate) {
        this.sinceDate = sinceDate;
    }

    public boolean isReportEverything() {
        return this.reportEverything;
    }

    public void setReportEverything(boolean reportEverything) {
        this.reportEverything = reportEverything;
    }

    public boolean isLastEventOfProject() {
        return this.lastEventOfProject;
    }

    public void setLastEventOfProject(boolean lastEventOfProject) {
        this.lastEventOfProject = lastEventOfProject;
    }

    public boolean isReportCheckouts() {
        return this.reportCheckouts;
    }

    public void setReportCheckouts(boolean reportCheckout) {
        this.reportCheckouts = reportCheckout;
    }

    public String getSinceRevision() {
        return this.sinceRevision;
    }

    public void setSinceRevision(String sinceRevision) {
        this.sinceRevision = sinceRevision;
    }

    public boolean isReportTags() {
        return this.reportTags;
    }

    public void setReportTags(boolean reportTags) {
        this.reportTags = reportTags;
    }

    public String getSinceTag() {
        return this.sinceTag;
    }

    public void setSinceTag(String sinceTag) {
        this.sinceTag = sinceTag;
    }

    public boolean isForWorkingDirectory() {
        return this.forWorkingDirectory;
    }

    public void setForWorkingDirectory(boolean forWorkingDirectory) {
        this.forWorkingDirectory = forWorkingDirectory;
    }

    public String getReportEventType() {
        return this.reportEventType;
    }

    public void setReportEventType(String reportEventType) {
        this.reportEventType = reportEventType;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String[] getLastEventForFile() {
        return this.lastEventForFile;
    }

    public void setLastEventForFile(String[] lastEventForFile) {
        this.lastEventForFile = lastEventForFile;
    }

    public void addLastEventForFile(String newFile) {
        this.lastEventForFile = this.addNewValue(this.lastEventForFile, newFile);
    }

    public String[] getReportOnModule() {
        return this.reportOnModule;
    }

    public void setReportOnModule(String[] reportOnModule) {
        this.reportOnModule = reportOnModule;
    }

    public void addReportOnModule(String newReportOnModule) {
        this.reportOnModule = this.addNewValue(this.reportOnModule, newReportOnModule);
    }

    public String[] getReportLastEventForModule() {
        return this.reportLastEventForModule;
    }

    public void setReportLastEventForModule(String[] reportLastEventForModule) {
        this.reportLastEventForModule = reportLastEventForModule;
    }

    public void addReportLastEventForModule(String newModule) {
        this.reportLastEventForModule = this.addNewValue(this.reportLastEventForModule, newModule);
    }

    public String[] getForUsers() {
        return this.forUsers;
    }

    public void setForUsers(String[] forUsers) {
        this.forUsers = forUsers;
    }

    public void addForUsers(String forUser) {
        this.forUsers = this.addNewValue(this.forUsers, forUser);
    }

    private String[] addNewValue(String[] arr, String newVal) {
        if (arr == null) {
            arr = new String[]{newVal};
            return arr;
        }
        String[] newValue = new String[arr.length + 1];
        for (int i = 0; i < arr.length; ++i) {
            newValue[i] = arr[i];
        }
        newValue[newValue.length] = newVal;
        return newValue;
    }
}

