/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.editors;

import java.io.EOFException;
import java.io.File;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.editors.EditorsBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.CommandRequest;

public class EditorsCommand
extends BasicCommand {
    private static final long serialVersionUID = -4979498123752526416L;

    public EditorsCommand() {
        this.resetCVSCommand();
    }

    @Override
    public Builder createBuilder(EventManager eventManager) {
        return new EditorsBuilder(eventManager);
    }

    @Override
    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        super.execute(clientServices, eventManager);
        try {
            this.addRequestForWorkingDirectory(clientServices);
            this.addArgumentRequests();
            this.addRequest(CommandRequest.EDITORS);
            clientServices.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (EOFException ex) {
            throw new CommandException(ex, CommandException.getLocalMessage("CommandException.EndOfFile", null));
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        finally {
            this.requests.clear();
        }
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    @Override
    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("editors ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            for (File file : files) {
                toReturn.append(file.getName());
                toReturn.append(' ');
            }
        }
        return toReturn.toString();
    }

    @Override
    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getOptString() {
        return "Rl";
    }

    @Override
    public void resetCVSCommand() {
        this.setRecursive(true);
    }

    @Override
    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer();
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        return toReturn.toString();
    }
}

