/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.editors;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.editors.EditorsFileInfoContainer;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class EditorsBuilder
implements Builder {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("MMM dd hh:mm:ss yyyy");
    private final EventManager eventManager;
    private String editorsFileName = null;

    EditorsBuilder(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (!isErrorMessage) {
            this.parseLine(line);
        }
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }

    @Override
    public void outputDone() {
    }

    private boolean parseLine(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, "\t");
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        if (!line.startsWith("\t")) {
            this.editorsFileName = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) {
                return false;
            }
        } else if (this.editorsFileName == null) {
            return false;
        }
        String user = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String dateString = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String clientName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens()) {
            return false;
        }
        String localDirectory = tokenizer.nextToken();
        try {
            EditorsFileInfoContainer fileInfoContainer = this.parseEntries(localDirectory, this.editorsFileName, user, dateString, clientName);
            FileInfoEvent event = new FileInfoEvent(this, fileInfoContainer);
            this.eventManager.fireCVSEvent(event);
            return true;
        }
        catch (ParseException ex) {
            return false;
        }
    }

    private EditorsFileInfoContainer parseEntries(String localDirectory, String fileName, String user, String dateString, String clientName) throws ParseException {
        int lastSlashIndex = fileName.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            fileName = fileName.substring(lastSlashIndex + 1);
        }
        Date date = this.parseDate(dateString);
        File file = new File(localDirectory, fileName);
        return new EditorsFileInfoContainer(file, user, date, clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseDate(String dateString) throws ParseException {
        int firstSpaceIndex = Math.max(dateString.indexOf(32), 0);
        int lastSpaceIndex = Math.min(dateString.lastIndexOf(32), dateString.length());
        String modifiedDateString = dateString.substring(firstSpaceIndex, lastSpaceIndex).trim();
        DateFormat dateFormat = DATE_FORMAT;
        synchronized (dateFormat) {
            return DATE_FORMAT.parse(modifiedDateString);
        }
    }
}

