/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.commit;

import java.io.File;
import java.io.IOException;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.commit.CommitInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CommitBuilder
implements Builder {
    public static final String UNKNOWN = "commit: nothing known about `";
    public static final String EXAM_DIR = ": Examining";
    public static final String REMOVING = "Removing ";
    public static final String NEW_REVISION = "new revision:";
    public static final String INITIAL_REVISION = "initial revision:";
    public static final String DELETED_REVISION = "delete";
    public static final String DONE = "done";
    public static final String RCS_FILE = "RCS file: ";
    public static final String ADD = "commit: use `cvs add' to create an entry for ";
    public static final String COMMITTED = " <-- ";
    private CommitInformation commitInformation;
    private File fileDirectory;
    private final EventManager eventManager;
    private final String localPath;
    private final String repositoryRoot;
    private boolean isAdding;

    public CommitBuilder(EventManager eventManager, String localPath, String repositoryRoot) {
        this.eventManager = eventManager;
        this.localPath = localPath;
        this.repositoryRoot = repositoryRoot;
    }

    @Override
    public void outputDone() {
        if (this.commitInformation != null) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.commitInformation));
            this.commitInformation = null;
        }
    }

    @Override
    public void parseLine(String line, boolean isErrorMessage) {
        if (line.indexOf(UNKNOWN) >= 0) {
            this.outputDone();
            this.processUnknownFile(line.substring(line.indexOf(UNKNOWN) + UNKNOWN.length()).trim());
        } else if (line.indexOf(ADD) > 0) {
            this.processToAddFile(line.substring(line.indexOf(ADD) + ADD.length()).trim());
        } else {
            int c = line.indexOf(COMMITTED);
            if (c > 0) {
                File file;
                this.outputDone();
                String fileName = line.substring(c + COMMITTED.length()).trim();
                int nameIndex = fileName.lastIndexOf(47);
                if (nameIndex != -1) {
                    fileName = fileName.substring(nameIndex + 1);
                }
                if (this.fileDirectory == null) {
                    String reposPath = line.substring(0, c).trim();
                    if (reposPath.startsWith(this.repositoryRoot) && (reposPath = reposPath.substring(this.repositoryRoot.length())).startsWith("/")) {
                        reposPath = reposPath.substring(1);
                    }
                    if ((c = reposPath.lastIndexOf(47)) > 0) {
                        reposPath = reposPath.substring(0, c);
                    }
                    file = this.findFile(fileName, reposPath);
                } else {
                    file = new File(this.fileDirectory, fileName);
                }
                this.processFile(file);
                if (this.isAdding) {
                    this.commitInformation.setType("Added");
                    this.isAdding = false;
                } else {
                    this.commitInformation.setType("Changed");
                }
            } else if (line.startsWith(REMOVING)) {
                this.outputDone();
                this.processFile(line.substring(REMOVING.length(), line.length() - 1));
                this.commitInformation.setType("Removed");
            } else if (line.indexOf(EXAM_DIR) >= 0) {
                this.fileDirectory = new File(this.localPath, line.substring(line.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim());
            } else if (line.startsWith(RCS_FILE)) {
                this.isAdding = true;
            } else if (line.startsWith(DONE)) {
                this.outputDone();
            } else if (line.startsWith(INITIAL_REVISION)) {
                this.processRevision(line.substring(INITIAL_REVISION.length()));
                this.commitInformation.setType("Added");
            } else if (line.startsWith(NEW_REVISION)) {
                this.processRevision(line.substring(NEW_REVISION.length()));
            }
        }
    }

    private File createFile(String fileName) {
        return new File(this.localPath, fileName);
    }

    private void processUnknownFile(String line) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("Unknown");
        int index = line.indexOf(39);
        String fileName = line.substring(0, index).trim();
        this.commitInformation.setFile(this.createFile(fileName));
        this.outputDone();
    }

    private void processToAddFile(String line) {
        this.commitInformation = new CommitInformation();
        this.commitInformation.setType("To-be-added");
        String fileName = line.trim();
        if (fileName.endsWith(";")) {
            fileName = fileName.substring(0, fileName.length() - 2);
        }
        this.commitInformation.setFile(this.createFile(fileName));
        this.outputDone();
    }

    private void processFile(String filename) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        if (filename.startsWith("no file")) {
            filename = filename.substring(8);
        }
        this.commitInformation.setFile(this.createFile(filename));
    }

    private void processFile(File file) {
        if (this.commitInformation == null) {
            this.commitInformation = new CommitInformation();
        }
        this.commitInformation.setFile(file);
    }

    private void processRevision(String revision) {
        int index = revision.indexOf(59);
        if (index >= 0) {
            revision = revision.substring(0, index);
        }
        if (DELETED_REVISION.equals(revision = revision.trim())) {
            this.commitInformation.setType("Removed");
        }
        this.commitInformation.setRevision(revision);
    }

    @Override
    public void parseEnhancedMessage(String key, Object value) {
    }

    private File findFile(String fileName, String reposPath) {
        File file;
        File dir = new File(this.localPath);
        if (reposPath.endsWith("/Attic")) {
            reposPath = reposPath.substring(0, reposPath.length() - 6);
        }
        if ((file = this.quickFindFile(dir, fileName, reposPath)) != null) {
            return file;
        }
        return this.findFile(dir, fileName, reposPath);
    }

    private File findFile(File dir, String fileName, String reposPath) {
        if (this.isWorkForRepository(dir, reposPath)) {
            return new File(dir, fileName);
        }
        File file = null;
        File[] subFiles = dir.listFiles();
        if (subFiles != null) {
            File subFile;
            File[] arr$ = subFiles;
            int len$ = arr$.length;
            for (int i$ = 0; !(i$ >= len$ || (subFile = arr$[i$]).isDirectory() && (file = this.findFile(subFile, fileName, reposPath)) != null); ++i$) {
            }
        }
        return file;
    }

    private File quickFindFile(File dir, String fileName, String reposPath) {
        do {
            File deepDir;
            if (!this.isWorkForRepository(deepDir = new File(dir, reposPath), reposPath) || !this.isUnderLocalPath(deepDir)) continue;
            return new File(deepDir, fileName);
        } while ((dir = dir.getParentFile()) != null);
        return null;
    }

    private boolean isWorkForRepository(File dir, String reposPath) {
        try {
            String repository = this.eventManager.getClientServices().getRepositoryForDirectory(dir);
            String root = this.eventManager.getClientServices().getRepository();
            if (repository.startsWith(root)) {
                repository = repository.substring(root.length() + 1);
            }
            return reposPath.equals(repository);
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isUnderLocalPath(File dir) {
        File localDir = new File(this.localPath);
        while (dir != null) {
            if (dir.equals(localDir)) {
                return true;
            }
            dir = dir.getParentFile();
        }
        return false;
    }
}

