/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class RannotateCommand
extends BasicCommand {
    private static final long serialVersionUID = 1803697825415871937L;
    private final List<String> modules = new LinkedList<String>();
    private final List<String> expandedModules = new LinkedList<String>();
    private boolean useHeadIfNotFound;
    private String annotateByDate;
    private String annotateByRevision;

    public RannotateCommand() {
        this.resetCVSCommand();
    }

    public void setModule(String module) {
        this.modules.add(module);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] modules) {
        this.clearModules();
        if (modules == null) {
            return;
        }
        for (String module : modules) {
            this.modules.add(module);
        }
    }

    public String[] getModules() {
        String[] mods = new String[this.modules.size()];
        mods = this.modules.toArray(mods);
        return mods;
    }

    @Override
    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        client.ensureConnection();
        this.requests = new LinkedList();
        if (client.isFirstCommand()) {
            this.requests.add(new RootRequest(client.getRepository()));
        }
        Iterator<String> i$ = this.modules.iterator();
        while (i$.hasNext()) {
            String string;
            String module = string = i$.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.expandedModules.clear();
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(new ExpandModulesRequest());
        try {
            client.processRequests(this.requests);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
        this.requests.clear();
        this.postExpansionExecute(client, em);
    }

    @Override
    public void moduleExpanded(ModuleExpansionEvent e) {
        this.expandedModules.add(e.getModule());
    }

    private void postExpansionExecute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        super.execute(client, em);
        if (!this.isRecursive()) {
            this.requests.add(1, new ArgumentRequest("-l"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(1, new ArgumentRequest("-f"));
        }
        if (this.annotateByDate != null && this.annotateByDate.length() > 0) {
            this.requests.add(1, new ArgumentRequest("-D"));
            this.requests.add(2, new ArgumentRequest(this.getAnnotateByDate()));
        }
        if (this.annotateByRevision != null && this.annotateByRevision.length() > 0) {
            this.requests.add(1, new ArgumentRequest("-r"));
            this.requests.add(2, new ArgumentRequest(this.getAnnotateByRevision()));
        }
        Iterator<String> i$ = this.modules.iterator();
        while (i$.hasNext()) {
            String string;
            String module = string = i$.next();
            this.requests.add(new ArgumentRequest(module));
        }
        this.requests.add(new DirectoryRequest(".", client.getRepository()));
        this.requests.add(CommandRequest.RANNOTATE);
        try {
            client.processRequests(this.requests);
            this.requests.clear();
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CommandException(ex, ex.getLocalizedMessage());
        }
    }

    @Override
    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("rannotate ");
        toReturn.append(this.getCVSArguments());
        if (this.modules != null && this.modules.size() > 0) {
            Iterator<String> i$ = this.modules.iterator();
            while (i$.hasNext()) {
                String string;
                String module = string = i$.next();
                toReturn.append(module);
                toReturn.append(' ');
            }
        } else {
            String localizedMsg = CommandException.getLocalMessage("ExportCommand.moduleEmpty.text");
            toReturn.append(" ");
            toReturn.append(localizedMsg);
        }
        return toReturn.toString();
    }

    @Override
    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.getAnnotateByRevision() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getAnnotateByRevision());
            toReturn.append(" ");
        }
        if (this.getAnnotateByDate() != null) {
            toReturn.append("-D ");
            toReturn.append(this.getAnnotateByDate());
            toReturn.append(" ");
        }
        if (this.isUseHeadIfNotFound()) {
            toReturn.append("-f ");
        }
        return toReturn.toString();
    }

    @Override
    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'r') {
            this.setAnnotateByRevision(optArg);
        } else if (opt == 'D') {
            this.setAnnotateByDate(optArg);
        } else if (opt == 'f') {
            this.setUseHeadIfNotFound(true);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setAnnotateByDate(null);
        this.setAnnotateByRevision(null);
        this.setUseHeadIfNotFound(false);
    }

    @Override
    public String getOptString() {
        return "Rlr:D:f";
    }

    @Override
    public Builder createBuilder(EventManager eventMan) {
        return new AnnotateBuilder(eventMan, this);
    }

    @Override
    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    public String getAnnotateByDate() {
        return this.annotateByDate;
    }

    public void setAnnotateByDate(String annotateByDate) {
        this.annotateByDate = annotateByDate;
    }

    public String getAnnotateByRevision() {
        return this.annotateByRevision;
    }

    public void setAnnotateByRevision(String annotateByRevision) {
        this.annotateByRevision = annotateByRevision;
    }
}

