/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.CVSSCM;
import hudson.scm.CvsModule;
import hudson.scm.CvsModuleLocationType;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.CvsRepositoryLocation;
import hudson.scm.ExcludedRegion;
import hudson.scm.RepositoryBrowser;
import hudson.scm.cvs.Messages;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.netbeans.lib.cvsclient.CVSRoot;

@ExportedBean
public class CvsRepository
extends AbstractDescribableImpl<CvsRepository>
implements Serializable {
    private static final long serialVersionUID = -5137002480695525335L;
    private static final Map<Locale, ListBoxModel> compressionLevels = new HashMap<Locale, ListBoxModel>();
    private final String cvsRoot;
    private final CvsRepositoryItem[] repositoryItems;
    private final int compressionLevel;
    private final ExcludedRegion[] excludedRegions;
    private final Secret password;
    private final boolean passwordRequired;
    private final CVSRepositoryBrowser repositoryBrowser;
    @Deprecated
    private transient CvsModule[] modules;

    @DataBoundConstructor
    public CvsRepository(String cvsRoot, boolean passwordRequired, String password, List<CvsRepositoryItem> repositoryItems, List<ExcludedRegion> excludedRegions, int compressionLevel, CVSRepositoryBrowser repositoryBrowser) {
        this.cvsRoot = cvsRoot;
        this.repositoryItems = repositoryItems.toArray(new CvsRepositoryItem[repositoryItems.size()]);
        this.compressionLevel = compressionLevel;
        this.excludedRegions = excludedRegions.toArray(new ExcludedRegion[excludedRegions.size()]);
        this.password = passwordRequired ? Secret.fromString((String)password) : null;
        this.passwordRequired = passwordRequired;
        this.repositoryBrowser = repositoryBrowser;
    }

    @Exported
    public String getCvsRoot() {
        return this.cvsRoot;
    }

    @Exported
    public CvsRepositoryItem[] getRepositoryItems() {
        return (CvsRepositoryItem[])this.repositoryItems.clone();
    }

    @Exported
    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    @Exported
    public ExcludedRegion[] getExcludedRegions() {
        return this.excludedRegions;
    }

    @Exported
    public Secret getPassword() {
        return this.password;
    }

    @Exported
    public boolean isPasswordRequired() {
        return this.passwordRequired;
    }

    @Exported
    public CVSRepositoryBrowser getRepositoryBrowser() {
        return this.repositoryBrowser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.compressionLevel;
        result = 31 * result + (this.cvsRoot == null ? 0 : this.cvsRoot.hashCode());
        result = 31 * result + (this.repositoryBrowser == null ? 0 : ((Object)((Object)this.repositoryBrowser)).hashCode());
        result = 31 * result + Arrays.hashCode(this.excludedRegions);
        result = 31 * result + Arrays.hashCode(this.repositoryItems);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CvsRepository other = (CvsRepository)obj;
        if (this.compressionLevel != other.compressionLevel) {
            return false;
        }
        if (this.cvsRoot == null ? other.cvsRoot != null : !this.cvsRoot.equals(other.cvsRoot)) {
            return false;
        }
        if (this.repositoryBrowser == null ? other.repositoryBrowser != null : !((Object)((Object)this.repositoryBrowser)).equals((Object)other.repositoryBrowser)) {
            return false;
        }
        if (!Arrays.equals(this.excludedRegions, other.excludedRegions)) {
            return false;
        }
        return Arrays.equals(this.repositoryItems, other.repositoryItems);
    }

    public Object readResolve() {
        if (null == this.modules) {
            return this;
        }
        HashMap<CvsRepositoryLocation.HeadRepositoryLocation, ArrayList<CvsModule>> itemMap = new HashMap<CvsRepositoryLocation.HeadRepositoryLocation, ArrayList<CvsModule>>();
        for (CvsModule module : this.modules) {
            CvsRepositoryLocation repositoryLocation = module.getModuleLocation().getLocationType() == CvsModuleLocationType.HEAD ? new CvsRepositoryLocation.HeadRepositoryLocation() : (module.getModuleLocation().getLocationType() == CvsModuleLocationType.BRANCH ? new CvsRepositoryLocation.BranchRepositoryLocation(module.getModuleLocation().getLocationName(), module.getModuleLocation().isUseHeadIfNotFound()) : new CvsRepositoryLocation.TagRepositoryLocation(module.getModuleLocation().getLocationName(), module.getModuleLocation().isUseHeadIfNotFound()));
            ArrayList<CvsModule> itemList = (ArrayList<CvsModule>)itemMap.get(repositoryLocation);
            if (null == itemList) {
                itemList = new ArrayList<CvsModule>();
                itemMap.put((CvsRepositoryLocation.HeadRepositoryLocation)repositoryLocation, itemList);
            }
            itemList.add(module);
        }
        ArrayList<CvsRepositoryItem> repositoryItems = new ArrayList<CvsRepositoryItem>();
        for (Map.Entry entry : itemMap.entrySet()) {
            repositoryItems.add(new CvsRepositoryItem((CvsRepositoryLocation)entry.getKey(), ((List)entry.getValue()).toArray(new CvsModule[((List)entry.getValue()).size()])));
        }
        return new CvsRepository(this.cvsRoot, this.passwordRequired, null == this.password ? null : this.password.getPlainText(), repositoryItems, Arrays.asList(this.excludedRegions), this.compressionLevel, null);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CvsRepository> {
        public String getDisplayName() {
            return "CVS Repository";
        }

        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return CVSSCM.DescriptorImpl.getOrDie().getBrowserDescriptors();
        }

        public FormValidation doCheckCvsRoot(@QueryParameter String value) throws IOException {
            String v = Util.fixEmpty((String)value);
            if (v == null) {
                return FormValidation.error((String)Messages.CVSSCM_MissingCvsroot());
            }
            try {
                CVSRoot.parse((String)v);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((String)Messages.CVSSCM_InvalidCvsroot());
            }
            return FormValidation.ok();
        }

        private static ListBoxModel.Option option(String i) {
            return new ListBoxModel.Option(i, i);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final ListBoxModel doFillCompressionLevelItems() {
            Map<Locale, ListBoxModel> map = compressionLevels;
            synchronized (map) {
                ListBoxModel model = compressionLevels.get(LocaleProvider.getLocale());
                if (model == null) {
                    model = DescriptorImpl.createCompressionLevelModel();
                    compressionLevels.put(LocaleProvider.getLocale(), model);
                }
                return model;
            }
        }

        private static final ListBoxModel createCompressionLevelModel() {
            return new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option(Messages.CVSSCM_SystemDefault(), "-1"), new ListBoxModel.Option(Messages.CVSSCM_NoCompression(), "0"), DescriptorImpl.option("1"), DescriptorImpl.option("2"), new ListBoxModel.Option("3 (" + Messages.CVSSCM_Recommended() + ")", "3"), DescriptorImpl.option("4"), DescriptorImpl.option("5"), DescriptorImpl.option("6"), DescriptorImpl.option("7"), DescriptorImpl.option("8"), DescriptorImpl.option("9")});
        }
    }
}

