/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.scm.CvsModuleLocation;
import hudson.scm.cvs.Messages;
import hudson.util.FormValidation;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public class CvsModule
extends AbstractDescribableImpl<CvsModule>
implements Serializable {
    private static final long serialVersionUID = 8450427422042269152L;
    private final String localName;
    private final String remoteName;
    private final String projectsetFileName;
    @Deprecated
    private transient CvsModuleLocation moduleLocation;

    public CvsModule(String remoteName, String localName) {
        this(remoteName, localName, null);
    }

    @DataBoundConstructor
    public CvsModule(String remoteName, String localName, String projectsetFileName) {
        this.remoteName = remoteName;
        this.localName = localName;
        this.projectsetFileName = projectsetFileName;
    }

    @Exported
    public String getLocalName() {
        return this.localName;
    }

    @Exported
    public String getRemoteName() {
        return this.remoteName;
    }

    @Exported
    public String getProjectsetFileName() {
        return this.projectsetFileName;
    }

    @Exported
    @Deprecated
    public CvsModuleLocation getModuleLocation() {
        return this.moduleLocation;
    }

    public String getCheckoutName() {
        return this.isAlternativeCheckoutName() ? this.localName : this.remoteName;
    }

    public boolean isAlternativeCheckoutName() {
        return !"".equals(Util.fixNull((String)this.localName));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.remoteName == null ? 0 : this.remoteName.hashCode());
        result = 31 * result + (this.projectsetFileName == null ? 0 : this.projectsetFileName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CvsModule other = (CvsModule)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        if (this.remoteName == null ? other.remoteName != null : !this.remoteName.equals(other.remoteName)) {
            return false;
        }
        return !(this.projectsetFileName == null ? other.projectsetFileName != null : !this.projectsetFileName.equals(other.projectsetFileName));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CvsModule> {
        public String getDisplayName() {
            return "CVS Module";
        }

        public FormValidation doCheckRemoteName(@QueryParameter String value) {
            String v = Util.fixNull((String)value);
            if ("".equals(v)) {
                return FormValidation.error((String)Messages.CVSSCM_MissingRemoteName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectsetFileName(@QueryParameter String value) {
            String v = Util.fixNull((String)value);
            if ("".equals(v)) {
                return FormValidation.error((String)Messages.CVSSCM_MissingProjectsetName());
            }
            return FormValidation.ok();
        }

        private FormValidation doCheckLocationName(String value, String location) {
            String v = Util.fixNull((String)value);
            if (v.equals("HEAD")) {
                return FormValidation.error((String)Messages.CVSSCM_HeadIsNotTag(location));
            }
            if (!v.equals(v.trim())) {
                return FormValidation.error((String)Messages.CVSSCM_TagNameInvalid(location));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBranchName(@QueryParameter String branchName) {
            return this.doCheckLocationName(branchName, Messages.CVSSCM_Branch());
        }

        public FormValidation doCheckTagName(@QueryParameter String tagName) {
            return this.doCheckLocationName(tagName, Messages.CVSSCM_Tag());
        }
    }
}

