/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.EnvVars;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CvsChangeSet;
import hudson.scm.CvsFile;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryLocation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.cvsclient.CVSRoot;

public abstract class CvsLog {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Pattern DOT_PATTERN = Pattern.compile("(([0-9]+\\.)+)0\\.([0-9]+)");
    private static final String CHANGE_DIVIDER = "----------------------------";
    private static final String FILE_DIVIDER = "===========================";

    protected abstract Reader read() throws IOException;

    protected abstract void dispose();

    public CvsChangeSet mapCvsLog(String cvsRoot, CvsRepositoryLocation location, CvsRepository repository, EnvVars envVars) throws IOException {
        String line;
        ArrayList<CVSChangeLogSet.CVSChangeLog> changes = new ArrayList<CVSChangeLogSet.CVSChangeLog>();
        HashMap<String, CvsFile> files = new HashMap<String, CvsFile>();
        CVSChangeLogSet.File file = null;
        CVSChangeLogSet.CVSChangeLog change = null;
        HashMap<String, String> branches = new HashMap<String, String>();
        TreeSet<String> tagNames = new TreeSet<String>();
        TreeSet<String> branchNames = new TreeSet<String>();
        BufferedReader reader = new BufferedReader(this.read());
        Status status = Status.FILE_NAME;
        String previousLine = null;
        String prePreviousLine = null;
        while ((line = reader.readLine()) != null) {
            switch (status.ordinal()) {
                case 0: {
                    branches.clear();
                    file = new CVSChangeLogSet.File();
                    status = this.parseFileName(line, file, status, cvsRoot);
                    break;
                }
                case 1: {
                    branches.clear();
                    file = new CVSChangeLogSet.File();
                    status = this.parseFileName(previousLine, file, status, cvsRoot);
                }
                case 5: {
                    status = this.parseBranchNames(line, status, branches, branchNames, tagNames);
                    break;
                }
                case 4: {
                    status = this.parseChangeVersion(line, file, status);
                    break;
                }
                case 2: {
                    change = new CVSChangeLogSet.CVSChangeLog();
                    change.setRepository(repository);
                    status = this.parseChangeHeader(line, file, change, status);
                    break;
                }
                case 3: {
                    status = this.processComment(line, file, change, status, branches, previousLine, changes, files, location, prePreviousLine, envVars);
                }
            }
            prePreviousLine = previousLine;
            previousLine = line;
        }
        if (status == Status.CHANGE_COMMENT) {
            status = this.processComment(null, file, change, Status.CHANGE_COMMENT, branches, line, changes, files, location, previousLine, envVars);
        }
        if (status == Status.CHANGE_COMMENT) {
            this.processComment(null, file, change, Status.CHANGE_COMMENT, branches, null, changes, files, location, line, envVars);
        }
        reader.close();
        this.dispose();
        return new CvsChangeSet(new ArrayList<CvsFile>(files.values()), changes, branchNames, tagNames);
    }

    private Status parseFileName(String line, CVSChangeLogSet.File file, Status currentStatus, String cvsRoot) {
        if (!line.startsWith("RCS file:")) {
            return currentStatus;
        }
        String fileName = line.substring(10).trim();
        String filePath = fileName.substring(0, fileName.length() - 2);
        file.setFullName(filePath);
        String rootName = CVSRoot.parse((String)cvsRoot).getRepository();
        file.setName(filePath.substring(rootName.length() + 1));
        return Status.FILE_BRANCH_NAMES;
    }

    private Status parseBranchNames(String line, Status currentStatus, Map<String, String> branches, Set<String> branchNames, Set<String> tagNames) {
        if (line.startsWith("keyword substitution:")) {
            return Status.FILE_VERSION;
        }
        if (!line.startsWith("\t")) {
            return currentStatus;
        }
        String trimmedLine = line.trim();
        int colonLocation = trimmedLine.lastIndexOf(58);
        if (colonLocation == -1) {
            return currentStatus;
        }
        String name = trimmedLine.substring(0, colonLocation).trim();
        Matcher versionMatcher = DOT_PATTERN.matcher(trimmedLine.substring(colonLocation + 2));
        if (!versionMatcher.matches()) {
            tagNames.add(name);
            return currentStatus;
        }
        branchNames.add(name);
        branches.put(versionMatcher.group(1) + versionMatcher.group(3) + ".", name);
        return currentStatus;
    }

    private Status parseChangeVersion(String line, CVSChangeLogSet.File file, Status currentStatus) {
        if (line.startsWith("revision")) {
            file.setRevision(line.substring(9));
            return Status.CHANGE_HEADER;
        }
        if (line.startsWith(FILE_DIVIDER)) {
            return Status.FILE_NAME;
        }
        return currentStatus;
    }

    private Status parseChangeHeader(String line, CVSChangeLogSet.File file, CVSChangeLogSet.CVSChangeLog change, Status currentStatus) {
        if (!line.startsWith("date:")) {
            return currentStatus;
        }
        int semiColonIndex = line.indexOf(";");
        change.setChangeDateString(line.substring(6, semiColonIndex));
        String remainingLineContent = line.substring(semiColonIndex + 1);
        semiColonIndex = remainingLineContent.indexOf(";");
        change.setUser(remainingLineContent.substring(10, semiColonIndex));
        file.setDead(remainingLineContent.contains("state: dead;"));
        change.setMsg("");
        return Status.CHANGE_COMMENT;
    }

    private void parsePreviousChangeVersion(String line, CVSChangeLogSet.File file, CVSChangeLogSet.CVSChangeLog change, Map<String, String> branches, List<CVSChangeLogSet.CVSChangeLog> changes, Map<String, CvsFile> files, CvsRepositoryLocation location, EnvVars envVars) {
        if (!line.startsWith("revision")) {
            throw new IllegalStateException("Unexpected line from CVS log: " + line);
        }
        String revision = line.substring(9);
        file.setPrevrevision(revision);
        this.saveChange(file, change, branches, changes, files, location, envVars);
        file.setRevision(revision);
    }

    private Status processComment(String line, CVSChangeLogSet.File file, CVSChangeLogSet.CVSChangeLog change, Status currentStatus, Map<String, String> branches, String previousLine, List<CVSChangeLogSet.CVSChangeLog> changes, Map<String, CvsFile> files, CvsRepositoryLocation location, String prePreviousLine, EnvVars envVars) {
        if (line != null && line.startsWith(FILE_DIVIDER)) {
            if (previousLine.equals(CHANGE_DIVIDER)) {
                this.updateChangeMessage(change, previousLine);
            }
            return currentStatus;
        }
        if (previousLine != null && previousLine.startsWith(FILE_DIVIDER)) {
            if (line != null && line.isEmpty()) {
                return currentStatus;
            }
            this.updateChangeMessage(change, previousLine);
        } else {
            if (prePreviousLine != null && prePreviousLine.startsWith(FILE_DIVIDER)) {
                if ((previousLine == null || previousLine.isEmpty()) && (line == null || line.startsWith("RCS file:"))) {
                    this.saveChange(file, change, branches, changes, files, location, envVars);
                    return Status.FILE_NAME_PREVIOUS_LINE;
                }
                this.updateChangeMessage(change, prePreviousLine);
                this.updateChangeMessage(change, previousLine);
                return currentStatus;
            }
            if (previousLine != null && previousLine.startsWith(CHANGE_DIVIDER)) {
                if (line != null && line.startsWith("revision")) {
                    this.parsePreviousChangeVersion(line, file, change, branches, changes, files, location, envVars);
                    return Status.CHANGE_HEADER;
                }
                this.updateChangeMessage(change, previousLine);
                this.updateChangeMessage(change, line);
            } else {
                if (line != null && line.startsWith(CHANGE_DIVIDER)) {
                    return currentStatus;
                }
                this.updateChangeMessage(change, line);
            }
        }
        return currentStatus;
    }

    private void updateChangeMessage(CVSChangeLogSet.CVSChangeLog change, String line) {
        Object message = change.getMsg();
        message = ((String)message).isEmpty() ? (String)message + line : (String)message + LINE_SEPARATOR + line;
        change.setMsg((String)message);
    }

    private void saveChange(CVSChangeLogSet.File file, CVSChangeLogSet.CVSChangeLog change, Map<String, String> branches, List<CVSChangeLogSet.CVSChangeLog> changes, Map<String, CvsFile> files, CvsRepositoryLocation location, EnvVars envVars) {
        String branch = this.getBranchNameForRevision(file.getRevision(), branches);
        if (branch == null && !(location instanceof CvsRepositoryLocation.HeadRepositoryLocation)) {
            return;
        }
        if (branch != null && location instanceof CvsRepositoryLocation.HeadRepositoryLocation) {
            return;
        }
        if (!(location instanceof CvsRepositoryLocation.HeadRepositoryLocation) && !envVars.expand(location.getLocationName()).equals(branch)) {
            return;
        }
        CVSChangeLogSet.CVSChangeLog currentChange = change;
        boolean addChange = true;
        for (CVSChangeLogSet.CVSChangeLog existingChange : changes) {
            if (!change.canBeMergedWith(existingChange)) continue;
            currentChange = existingChange;
            addChange = false;
            break;
        }
        if (!files.containsKey(file.getFullName())) {
            CvsFile cvsFile = CvsFile.make(file.getFullName(), file.getRevision(), file.isDead());
            files.put(file.getFullName(), cvsFile);
        }
        if (addChange) {
            changes.add(currentChange);
        }
        CVSChangeLogSet.File localFile = new CVSChangeLogSet.File();
        localFile.setRevision(file.getRevision());
        localFile.setDead(file.isDead());
        localFile.setFullName(file.getFullName());
        localFile.setName(file.getName());
        localFile.setPrevrevision(file.getPrevrevision());
        currentChange.addFile(localFile);
    }

    private String getBranchNameForRevision(String revision, Map<String, String> branches) {
        if (null == revision) {
            return null;
        }
        for (Map.Entry<String, String> e : branches.entrySet()) {
            if (!revision.startsWith(e.getKey()) || revision.substring(e.getKey().length()).indexOf(46) != -1) continue;
            return e.getValue();
        }
        return null;
    }

    private static enum Status {
        FILE_NAME,
        FILE_NAME_PREVIOUS_LINE,
        CHANGE_HEADER,
        CHANGE_COMMENT,
        FILE_VERSION,
        FILE_BRANCH_NAMES;

    }
}

