/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.Secret;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class CvsAuthentication
extends AbstractDescribableImpl<CvsAuthentication> {
    private String cvsRoot;
    private String username;
    private Secret password;

    @DataBoundConstructor
    public CvsAuthentication(String cvsRoot, String username, String password) {
        this.cvsRoot = cvsRoot;
        this.username = Util.fixNull((String)username);
        this.password = Secret.fromString((String)password);
    }

    @Exported
    public String getCvsRoot() {
        return this.cvsRoot;
    }

    @Exported
    public String getUsername() {
        return this.username;
    }

    @Exported
    public Secret getPassword() {
        return this.password;
    }

    @Extension
    public static class CvsAuthenticationDescriptor
    extends Descriptor<CvsAuthentication> {
        public String getDisplayName() {
            return "CVS Authentication";
        }
    }
}

