/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.User;
import hudson.scm.CVSChangeLogParser;
import hudson.scm.CVSSCM;
import hudson.scm.ChangeLogSet;
import hudson.scm.CvsRepository;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.digester3.Digester;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.SAXException;

public final class CVSChangeLogSet
extends ChangeLogSet<CVSChangeLog> {
    private static final String CHANGE_DATE_FORMATTER_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final List<CVSChangeLog> logs;

    public CVSChangeLogSet(AbstractBuild<?, ?> build, List<CVSChangeLog> logs) {
        super(build);
        this.logs = Collections.unmodifiableList(logs);
        for (CVSChangeLog log : logs) {
            log.setParent(this);
        }
    }

    public CVSChangeLogSet(Run<?, ?> build, RepositoryBrowser<?> browser, List<CVSChangeLog> logs) {
        super(build, browser);
        this.logs = Collections.unmodifiableList(logs);
        for (CVSChangeLog log : logs) {
            log.setParent(this);
        }
    }

    public List<CVSChangeLog> getLogs() {
        return this.logs;
    }

    public boolean isEmptySet() {
        return this.logs.isEmpty();
    }

    public Iterator<CVSChangeLog> iterator() {
        return this.logs.iterator();
    }

    public String getKind() {
        return "cvs";
    }

    public static CVSChangeLogSet parse(AbstractBuild<?, ?> build, java.io.File f) throws IOException, SAXException {
        ArrayList<CVSChangeLog> r = CVSChangeLogSet.parseFile(f);
        return new CVSChangeLogSet(build, r);
    }

    public static CVSChangeLogSet parse(Run<?, ?> build, RepositoryBrowser<?> browser, java.io.File f) throws IOException, SAXException {
        ArrayList<CVSChangeLog> r = CVSChangeLogSet.parseFile(f);
        return new CVSChangeLogSet(build, browser, r);
    }

    private static ArrayList<CVSChangeLog> parseFile(java.io.File f) throws IOException, SAXException {
        Digester digester = new Digester();
        digester.setXIncludeAware(false);
        if (!Boolean.getBoolean(CVSChangeLogParser.class.getName() + ".UNSAFE")) {
            try {
                digester.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                digester.setFeature("http://xml.org/sax/features/external-general-entities", false);
                digester.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                digester.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException ex) {
                throw new SAXException("Failed to securely configure CVS changelog parser", ex);
            }
        }
        ArrayList<CVSChangeLog> r = new ArrayList<CVSChangeLog>();
        digester.push(r);
        digester.addObjectCreate("*/entry", CVSChangeLog.class);
        digester.addBeanPropertySetter("*/entry/changeDate", "changeDateString");
        digester.addBeanPropertySetter("*/entry/date");
        digester.addBeanPropertySetter("*/entry/time");
        digester.addBeanPropertySetter("*/entry/author", "user");
        digester.addBeanPropertySetter("*/entry/msg");
        digester.addSetNext("*/entry", "add");
        digester.addObjectCreate("*/entry/file", File.class);
        digester.addBeanPropertySetter("*/entry/file/name");
        digester.addBeanPropertySetter("*/entry/file/fullName");
        digester.addBeanPropertySetter("*/entry/file/revision");
        digester.addBeanPropertySetter("*/entry/file/prevrevision");
        digester.addCallMethod("*/entry/file/dead", "setDead");
        digester.addSetNext("*/entry/file", "addFile");
        try {
            digester.parse(f);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse " + String.valueOf(f), e);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse " + String.valueOf(f), e);
        }
        for (int i = r.size() - 1; i >= 0; --i) {
            CVSChangeLog log = r.get(i);
            boolean merged = false;
            if (!log.isComplete()) {
                r.remove(log);
                continue;
            }
            for (int j = 0; j < i; ++j) {
                CVSChangeLog c = r.get(j);
                if (!c.canBeMergedWith(log)) continue;
                c.merge(log);
                merged = true;
                break;
            }
            if (!merged) continue;
            r.remove(log);
        }
        return r;
    }

    public void toFile(java.io.File changelogFile) throws IOException {
        String encoding = CVSSCM.DescriptorImpl.getOrDie().getChangelogEncoding();
        PrintStream output = new PrintStream((OutputStream)new FileOutputStream(changelogFile), true, encoding);
        SimpleDateFormat format = new SimpleDateFormat(CHANGE_DATE_FORMATTER_PATTERN);
        output.println("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>");
        output.println("<changelog>");
        Iterator<CVSChangeLog> iterator = this.iterator();
        while (iterator.hasNext()) {
            CVSChangeLog entry = iterator.next();
            output.println("\t<entry>");
            output.println("\t\t<changeDate>" + format.format(entry.getChangeDate()) + "</changeDate>");
            output.println("\t\t<author><![CDATA[" + String.valueOf(entry.getAuthor()) + "]]></author>");
            for (File file : entry.getFiles()) {
                output.println("\t\t<file>");
                output.println("\t\t\t<name><![CDATA[" + file.getName() + "]]></name>");
                output.println("\t\t\t<fullName><![CDATA[" + file.getFullName() + "]]></fullName>");
                output.println("\t\t\t<revision>" + file.getRevision() + "</revision>");
                String previousRevision = file.getPrevrevision();
                if (previousRevision != null) {
                    output.println("\t\t\t<prevrevision>" + previousRevision + "</prevrevision>");
                }
                if (file.isDead()) {
                    output.println("\t\t\t<dead />");
                }
                output.println("\t\t</file>");
            }
            output.println("\t\t<msg><![CDATA[" + entry.getMsg() + "]]></msg>");
            output.println("\t</entry>");
        }
        output.println("</changelog>");
        output.flush();
        output.close();
    }

    public static class CVSChangeLog
    extends ChangeLogSet.Entry
    implements Serializable {
        private static final DateFormat[] dateFormatters = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")};
        private String user;
        private String msg;
        private final List<File> files = new ArrayList<File>();
        private long changeDate;
        private CvsRepository repository;

        public boolean isComplete() {
            return this.changeDate != 0L && this.msg != null;
        }

        public boolean canBeMergedWith(CVSChangeLog that) {
            if (!this.getChangeDate().equals(that.getChangeDate())) {
                return false;
            }
            if (this.user == null && that.user != null) {
                return false;
            }
            if (that.user == null && this.user != null) {
                return false;
            }
            if (this.user != null && !this.user.equals(that.user)) {
                return false;
            }
            return this.getMsg().equals(that.getMsg());
        }

        protected void setParent(ChangeLogSet parent) {
            super.setParent(parent);
        }

        public void merge(CVSChangeLog that) {
            this.files.addAll(that.files);
            for (File f : that.files) {
                f.parent = this;
            }
        }

        public long getTimestamp() {
            return this.changeDate;
        }

        @Deprecated
        public void setDate(String date) {
        }

        @Deprecated
        public void setTime(String time) {
        }

        @Exported
        public Date getChangeDate() {
            if (this.changeDate == 0L) {
                return null;
            }
            return new Date(this.changeDate);
        }

        @Exported
        public CvsRepository getRepository() {
            return this.repository;
        }

        public void setRepository(CvsRepository repository) {
            this.repository = repository;
        }

        public void setChangeDate(Date newChangeDate) {
            this.changeDate = newChangeDate.getTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setChangeDateString(String changeDate) {
            Date parsedDate = null;
            DateFormat[] dateFormatArray = dateFormatters;
            synchronized (dateFormatters) {
                for (DateFormat format : dateFormatters) {
                    try {
                        parsedDate = format.parse(changeDate);
                        break;
                    }
                    catch (ParseException parseException) {
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                if (parsedDate == null) {
                    throw new RuntimeException(changeDate + " could not be parsed using any recognised date formatter.");
                }
                this.setChangeDate(parsedDate);
                return;
            }
        }

        @Exported
        public User getAuthor() {
            if (this.user == null) {
                return User.getUnknown();
            }
            return User.get((String)this.user);
        }

        public Collection<String> getAffectedPaths() {
            return new AbstractList<String>(){

                @Override
                public String get(int index) {
                    return files.get(index).getName();
                }

                @Override
                public int size() {
                    return files.size();
                }
            };
        }

        public void setUser(String author) {
            this.user = author;
        }

        @Exported
        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void addFile(File f) {
            f.parent = this;
            this.files.add(f);
        }

        @Exported
        public List<File> getFiles() {
            return this.files;
        }

        public Collection<File> getAffectedFiles() {
            return this.files;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
            result = 31 * result;
            result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
            result = 31 * result + (this.msg == null ? 0 : this.msg.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CVSChangeLog other = (CVSChangeLog)obj;
            if (this.user == null ? other.user != null : !this.user.equals(other.user)) {
                return false;
            }
            if (this.changeDate != other.changeDate) {
                return false;
            }
            if (this.files == null ? other.files != null : !this.files.equals(other.files)) {
                return false;
            }
            return !(this.msg == null ? other.msg != null : !this.msg.equals(other.msg));
        }
    }

    @ExportedBean(defaultVisibility=999)
    public static class File
    implements ChangeLogSet.AffectedFile,
    Serializable {
        private String name;
        private String fullName;
        private String revision;
        private String prevrevision;
        private boolean dead;
        private CVSChangeLog parent;

        public String getPath() {
            return this.getName();
        }

        @Exported
        public String getName() {
            return this.name;
        }

        @Exported
        public String getFullName() {
            if (this.fullName == null) {
                CVSSCM cvsscm;
                SCM scm = this.parent.getParent().build.getProject().getScm();
                this.fullName = scm instanceof CVSSCM ? ((cvsscm = (CVSSCM)scm).isFlatten() ? "/" + cvsscm.getRepositories()[0].getRepositoryItems()[0].getModules()[0].getCheckoutName() + "/" + this.name : "/" + this.name) : "/" + this.name;
            }
            return this.fullName;
        }

        public void setFullName(String fullName) {
            this.fullName = fullName;
        }

        public String getSimpleName() {
            int idx = this.name.lastIndexOf(47);
            if (idx > 0) {
                return this.name.substring(idx + 1);
            }
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Exported
        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        @Exported
        public String getPrevrevision() {
            return this.prevrevision;
        }

        public void setPrevrevision(String prevrevision) {
            this.prevrevision = prevrevision;
        }

        @Exported
        public boolean isDead() {
            return this.dead;
        }

        public void setDead(boolean dead) {
            this.dead = dead;
        }

        public void setDead() {
            this.setDead(this.dead);
        }

        @Exported
        public EditType getEditType() {
            if (this.dead) {
                return EditType.DELETE;
            }
            if (this.revision.equals("1.1")) {
                return EditType.ADD;
            }
            return EditType.EDIT;
        }

        public CVSChangeLog getParent() {
            return this.parent;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dead ? 1231 : 1237);
            result = 31 * result + (this.fullName == null ? 0 : this.fullName.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.prevrevision == null ? 0 : this.prevrevision.hashCode());
            result = 31 * result + (this.revision == null ? 0 : this.revision.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            File other = (File)obj;
            if (this.dead != other.dead) {
                return false;
            }
            if (this.fullName == null ? other.fullName != null : !this.fullName.equals(other.fullName)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.prevrevision == null ? other.prevrevision != null : !this.prevrevision.equals(other.prevrevision)) {
                return false;
            }
            return !(this.revision == null ? other.revision != null : !this.revision.equals(other.revision));
        }
    }

    public static class Revision {
        public final int[] numbers;

        public Revision(int[] numbers) {
            this.numbers = numbers;
            assert (numbers.length % 2 == 0);
        }

        public Revision(String s) {
            String[] tokens = s.split("\\.");
            this.numbers = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                this.numbers[i] = Integer.parseInt(tokens[i]);
            }
            assert (this.numbers.length % 2 == 0);
        }

        public Revision getPrevious() {
            if (this.numbers[this.numbers.length - 1] == 1) {
                int[] p = new int[this.numbers.length - 2];
                System.arraycopy(this.numbers, 0, p, 0, p.length);
                if (p.length == 0) {
                    return null;
                }
                return new Revision(p);
            }
            int[] p = (int[])this.numbers.clone();
            int n = p.length - 1;
            p[n] = p[n] - 1;
            return new Revision(p);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            for (int n : this.numbers) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(n);
            }
            return buf.toString();
        }
    }
}

