/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.extended_timer_trigger.ExtendedTimerTrigger;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterizedTimerTrigger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CronViewColumn
extends ListViewColumn {
    private static final String CRON_EXPRESSION_COMMENT_START = "#";
    private static final String EXTENDED_CRON_EXPRESSION_COMMENT_START = "//";
    private static final String CRON_EXPRESSION_COMMENT_COLOR = "var(--dark-green)";
    private static final String CRON_EXPRESSION_PARAM_COLOR = "var(--blue)";
    private boolean hideComments;

    @DataBoundConstructor
    public CronViewColumn() {
    }

    public boolean getHideComments() {
        return this.hideComments;
    }

    @DataBoundSetter
    public void setHideComments(boolean hideComments) {
        this.hideComments = hideComments;
    }

    private boolean hasPlugin(String pluginName) {
        return Jenkins.get().getPlugin(pluginName) != null;
    }

    private String getCronSpec(Trigger<?> trigger) {
        if (this.hasPlugin("extended-timer-trigger") && trigger instanceof ExtendedTimerTrigger) {
            ExtendedTimerTrigger ett = (ExtendedTimerTrigger)trigger;
            return ett.getCronSpec();
        }
        if (this.hasPlugin("parameterized-scheduler") && trigger instanceof ParameterizedTimerTrigger) {
            ParameterizedTimerTrigger ptt = (ParameterizedTimerTrigger)trigger;
            return ptt.getParameterizedSpecification();
        }
        return trigger.getSpec();
    }

    public String getCronTrigger(Job<?, ?> job, boolean hideComments) {
        if (!(job instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            return "";
        }
        ParameterizedJobMixIn.ParameterizedJob pj = (ParameterizedJobMixIn.ParameterizedJob)job;
        StringBuilder expression = new StringBuilder();
        boolean hasSourceCodeManagement = false;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            SCM sourceCodeManagement = project.getScm();
            hasSourceCodeManagement = sourceCodeManagement != null && !(sourceCodeManagement instanceof NullSCM);
        }
        Map triggers = pj.getTriggers();
        for (Trigger trigger : triggers.values()) {
            String cronExpression;
            if (trigger == null || (cronExpression = this.getCronSpec(trigger)) == null || cronExpression.isBlank()) continue;
            cronExpression = this.formatComments(cronExpression, hideComments, trigger);
            if (!hasSourceCodeManagement && trigger instanceof SCMTrigger) {
                expression.append("<i>(Disabled) </i>");
            }
            expression.append(this.getTriggerName(trigger)).append(":<br/><div class='jenkins-!-margin-left-1'>").append(cronExpression).append("</div>");
        }
        return expression.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatComments(String cronExpression, boolean hideComments, Trigger<?> trigger) {
        String[] expressionLines;
        boolean isExtendedTimerTrigger = this.hasPlugin("extended-timer-trigger") && trigger instanceof ExtendedTimerTrigger;
        boolean isParameterizedTrigger = this.hasPlugin("parameterized-scheduler") && trigger instanceof ParameterizedTimerTrigger;
        StringBuilder formattedExpression = new StringBuilder();
        for (String string : expressionLines = cronExpression.split("\n")) {
            String string2 = Util.escape((String)string).trim();
            if (string2.isBlank()) continue;
            boolean hasComment = string2.startsWith(CRON_EXPRESSION_COMMENT_START);
            boolean hasExtendedComment = isExtendedTimerTrigger && !string2.startsWith("%") && string2.contains(EXTENDED_CRON_EXPRESSION_COMMENT_START);
            int formatIndex = string2.indexOf(EXTENDED_CRON_EXPRESSION_COMMENT_START);
            if (isExtendedTimerTrigger && string2.startsWith("%")) {
                String string3 = "<b style='color: var(--blue);'>" + string2 + "</b>";
            }
            if (!hasComment && !hasExtendedComment) {
                void var11_11;
                if (isParameterizedTrigger && var11_15.contains("%")) {
                    String string4 = var11_15.replaceAll("(%.*)", "<b style='color: var(--blue);'>$1</b>");
                }
                formattedExpression.append((String)var11_11);
            } else if (hideComments) {
                if (hasComment || formatIndex == 0) continue;
                formattedExpression.append((CharSequence)var11_15, 0, formatIndex);
            } else if (hasComment) {
                formattedExpression.append("<b><em style='color: var(--dark-green);'>");
                formattedExpression.append((String)var11_15);
                formattedExpression.append("</em></b>");
            } else {
                formattedExpression.append((CharSequence)var11_15, 0, formatIndex);
                formattedExpression.append("<b><em style='color: var(--dark-green);'>");
                formattedExpression.append(var11_15.substring(formatIndex));
                formattedExpression.append("</em></b>");
            }
            formattedExpression.append("<br/>");
        }
        return formattedExpression.toString().trim();
    }

    private String getTriggerName(Trigger<?> trigger) {
        String type = trigger.getDescriptor().getDisplayName();
        if (type.isBlank()) {
            type = trigger instanceof SCMTrigger ? "SCM polling" : (trigger instanceof TimerTrigger ? "Build Trigger" : "Unknown Type");
        }
        return type;
    }

    @Extension
    @Symbol(value={"cronTrigger"})
    public static final class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Cron Trigger";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

