/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.Map;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CronViewColumn
extends ListViewColumn {
    private static final String CRON_EXPRESSION_COMMENT_START = "#";
    private static final String CRON_EXPRESSION_COMMENT_COLOR = "var(--dark-green)";
    private boolean hideComments;

    @DataBoundConstructor
    public CronViewColumn() {
    }

    public boolean getHideComments() {
        return this.hideComments;
    }

    @DataBoundSetter
    public void setHideComments(boolean hideComments) {
        this.hideComments = hideComments;
    }

    public String getCronTrigger(Job<?, ?> job, boolean hideComments) {
        if (!(job instanceof ParameterizedJobMixIn.ParameterizedJob)) {
            return "";
        }
        ParameterizedJobMixIn.ParameterizedJob pj = (ParameterizedJobMixIn.ParameterizedJob)job;
        StringBuilder expression = new StringBuilder();
        boolean hasSourceCodeManagement = false;
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            SCM sourceCodeManagement = project.getScm();
            hasSourceCodeManagement = sourceCodeManagement != null && !(sourceCodeManagement instanceof NullSCM);
        }
        Map triggers = pj.getTriggers();
        for (Trigger trigger : triggers.values()) {
            String cronExpression;
            if (trigger == null || (cronExpression = trigger.getSpec()) == null || cronExpression.isBlank()) continue;
            cronExpression = this.formatComments(cronExpression, hideComments);
            if (!hasSourceCodeManagement && trigger instanceof SCMTrigger) {
                expression.append("<i>(Disabled) </i>");
            }
            expression.append(this.getTriggerName(trigger)).append(": ").append(cronExpression);
        }
        return expression.toString();
    }

    private String formatComments(String cronExpression, boolean hideComments) {
        String[] expressionLines;
        if (!cronExpression.contains(CRON_EXPRESSION_COMMENT_START)) {
            return cronExpression;
        }
        StringBuilder formattedExpression = new StringBuilder();
        for (String expressionLine : expressionLines = cronExpression.split("\n")) {
            if ((expressionLine = Util.escape((String)expressionLine).trim()).isBlank()) continue;
            int commentStartIndex = expressionLine.indexOf(CRON_EXPRESSION_COMMENT_START);
            if (commentStartIndex < 0) {
                formattedExpression.append(expressionLine);
            } else {
                if (hideComments) {
                    formattedExpression.append(expressionLine, 0, commentStartIndex);
                    continue;
                }
                formattedExpression.append(expressionLine, 0, commentStartIndex);
                formattedExpression.append("<b><em style='color: var(--dark-green);'>");
                formattedExpression.append(expressionLine.substring(commentStartIndex));
                formattedExpression.append("</em></b>");
            }
            formattedExpression.append("<br/>");
        }
        return formattedExpression.toString().trim();
    }

    private String getTriggerName(Trigger<?> trigger) {
        String type = trigger.getDescriptor().getDisplayName();
        if (type.isBlank()) {
            type = trigger instanceof SCMTrigger ? "SCM polling" : (trigger instanceof TimerTrigger ? "Build Trigger" : "Unknown Type");
        }
        return type;
    }

    @Extension
    @Symbol(value={"cronTrigger"})
    public static final class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return "Cron Trigger";
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

