/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.matchers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class UsernameMatcher
implements CredentialsMatcher {
    private static final long serialVersionUID = -2166795904091485580L;
    @NonNull
    private final String username;

    public UsernameMatcher(@NonNull String username) {
        Objects.requireNonNull(username);
        this.username = username;
    }

    @Override
    public boolean matches(@NonNull Credentials item) {
        return item instanceof UsernameCredentials && this.username.equals(((UsernameCredentials)item).getUsername());
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsernameMatcher that = (UsernameMatcher)o;
        return this.username.equals(that.username);
    }

    public String toString() {
        return "UsernameMatcher{username='" + this.username + "'}";
    }
}

