/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@Extension
public class SystemCredentialsProvider
extends AbstractDescribableImpl<SystemCredentialsProvider>
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(SystemCredentialsProvider.class.getName());
    @Deprecated
    private transient List<Credentials> credentials = new CopyOnWriteArrayList<Credentials>();
    private Map<Domain, List<Credentials>> domainCredentialsMap = new CopyOnWriteMap.Hash();
    private transient StoreImpl store = new StoreImpl();

    public SystemCredentialsProvider() {
        try {
            XmlFile xml = SystemCredentialsProvider.getConfigFile();
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read the existing credentials", e);
        }
        this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
        this.credentials = null;
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void forceLoadDuringStartup() {
        SystemCredentialsProvider.getInstance();
    }

    public static XmlFile getConfigFile() {
        return new XmlFile((XStream)Jenkins.XSTREAM2, new File(Jenkins.get().getRootDir(), "credentials.xml"));
    }

    public static SystemCredentialsProvider getInstance() {
        return (SystemCredentialsProvider)((Object)ExtensionList.lookup(SystemCredentialsProvider.class).get(SystemCredentialsProvider.class));
    }

    public List<Credentials> getCredentials() {
        return this.domainCredentialsMap.get(Domain.global());
    }

    public List<DomainCredentials> getDomainCredentials() {
        return DomainCredentials.asList(this.getDomainCredentialsMap());
    }

    @NonNull
    public synchronized Map<Domain, List<Credentials>> getDomainCredentialsMap() {
        this.domainCredentialsMap = DomainCredentials.migrateListToMap(this.domainCredentialsMap, this.credentials);
        return this.domainCredentialsMap;
    }

    public synchronized void setDomainCredentialsMap(Map<Domain, List<Credentials>> domainCredentialsMap) {
        this.domainCredentialsMap = DomainCredentials.toCopyOnWriteMap(domainCredentialsMap);
    }

    private void checkPermission(Permission p) {
        Jenkins.get().checkPermission(p);
    }

    private void checkedSave(Permission p) throws IOException {
        this.checkPermission(p);
        try (ACLContext ignored = ACL.as2((Authentication)ACL.SYSTEM2);){
            this.save();
        }
    }

    private synchronized boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            boolean modified = false;
            for (Credentials c : credentials) {
                if (list.contains(c)) continue;
                list.add(c);
                modified = true;
            }
            if (modified) {
                this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            }
            return modified;
        }
        domainCredentialsMap.put(domain, new ArrayList<Credentials>(credentials));
        this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
        return true;
    }

    private synchronized boolean removeDomain(@NonNull Domain domain) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            domainCredentialsMap.remove(domain);
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }
        return false;
    }

    private synchronized boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
        this.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(current)) {
            domainCredentialsMap.put(replacement, domainCredentialsMap.remove(current));
            this.checkedSave(CredentialsProvider.MANAGE_DOMAINS);
            return true;
        }
        return false;
    }

    private synchronized boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
        this.checkPermission(CredentialsProvider.CREATE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            if (list.contains(credentials)) {
                return false;
            }
            list.add(credentials);
            this.checkedSave(CredentialsProvider.CREATE);
            return true;
        }
        return false;
    }

    @NonNull
    private synchronized List<Credentials> getCredentials(@NonNull Domain domain) {
        if (Jenkins.get().hasPermission(CredentialsProvider.VIEW)) {
            List<Credentials> list = this.getDomainCredentialsMap().get(domain);
            if (list == null || list.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(new ArrayList<Credentials>(list));
        }
        return Collections.emptyList();
    }

    private synchronized boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
        this.checkPermission(CredentialsProvider.DELETE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            List<Credentials> list = domainCredentialsMap.get(domain);
            if (!list.contains(credentials)) {
                return false;
            }
            list.remove(credentials);
            this.checkedSave(CredentialsProvider.DELETE);
            return true;
        }
        return false;
    }

    private synchronized boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
        this.checkPermission(CredentialsProvider.UPDATE);
        Map<Domain, List<Credentials>> domainCredentialsMap = this.getDomainCredentialsMap();
        if (domainCredentialsMap.containsKey(domain)) {
            if ((current instanceof IdCredentials || replacement instanceof IdCredentials) && !current.equals(replacement)) {
                throw new IllegalArgumentException("Credentials' IDs do not match, will not update.");
            }
            List<Credentials> list = domainCredentialsMap.get(domain);
            int index = list.indexOf(current);
            if (index == -1) {
                return false;
            }
            list.set(index, replacement);
            this.checkedSave(CredentialsProvider.UPDATE);
            return true;
        }
        return false;
    }

    private synchronized StoreImpl getStore() {
        if (this.store == null) {
            this.store = new StoreImpl();
        }
        return this.store;
    }

    public void save() throws IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        XmlFile configFile = SystemCredentialsProvider.getConfigFile();
        configFile.write((Object)this);
        SaveableListener.fireOnChange((Saveable)this, (XmlFile)configFile);
    }

    @ExportedBean
    public static class StoreImpl
    extends CredentialsStore {
        private final UserFacingAction storeAction = new UserFacingAction();

        public StoreImpl() {
            super(ProviderImpl.class);
        }

        @Override
        @NonNull
        public ModelObject getContext() {
            return Jenkins.get();
        }

        @Override
        public boolean hasPermission2(@NonNull Authentication a, @NonNull Permission permission) {
            return this.getACL().hasPermission2(a, permission);
        }

        @Override
        @NonNull
        public ACL getACL() {
            return Jenkins.get().getACL();
        }

        @Override
        @Exported
        @NonNull
        public List<Domain> getDomains() {
            return Collections.unmodifiableList(new ArrayList<Domain>(SystemCredentialsProvider.getInstance().getDomainCredentialsMap().keySet()));
        }

        @Override
        @Exported
        @NonNull
        public List<Credentials> getCredentials(@NonNull Domain domain) {
            return SystemCredentialsProvider.getInstance().getCredentials(domain);
        }

        @Override
        public boolean addDomain(@NonNull Domain domain, List<Credentials> credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().addDomain(domain, credentials);
        }

        @Override
        public boolean removeDomain(@NonNull Domain domain) throws IOException {
            return SystemCredentialsProvider.getInstance().removeDomain(domain);
        }

        @Override
        public boolean updateDomain(@NonNull Domain current, @NonNull Domain replacement) throws IOException {
            return SystemCredentialsProvider.getInstance().updateDomain(current, replacement);
        }

        @Override
        public boolean addCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().addCredentials(domain, credentials);
        }

        @Override
        public boolean removeCredentials(@NonNull Domain domain, @NonNull Credentials credentials) throws IOException {
            return SystemCredentialsProvider.getInstance().removeCredentials(domain, credentials);
        }

        @Override
        public boolean updateCredentials(@NonNull Domain domain, @NonNull Credentials current, @NonNull Credentials replacement) throws IOException {
            return SystemCredentialsProvider.getInstance().updateCredentials(domain, current, replacement);
        }

        @Override
        @Nullable
        public CredentialsStoreAction getStoreAction() {
            return this.storeAction;
        }

        @Override
        public void save() throws IOException {
            if (BulkChange.contains((Saveable)this)) {
                return;
            }
            SystemCredentialsProvider.getInstance().save();
        }
    }

    @ExportedBean
    public static class UserFacingAction
    extends CredentialsStoreAction {
        @Override
        @NonNull
        public CredentialsStore getStore() {
            return SystemCredentialsProvider.getInstance().getStore();
        }

        @Override
        public String getIconFileName() {
            return this.isVisible() ? "/plugin/credentials/images/system-store.svg" : null;
        }

        @Override
        public String getIconClassName() {
            return this.isVisible() ? "icon-credentials-system-store icon-sm" : null;
        }

        @Override
        public String getDisplayName() {
            return Messages.SystemCredentialsProvider_UserFacingAction_DisplayName();
        }
    }

    @Extension
    public static class ProviderImpl
    extends CredentialsProvider {
        private static final Set<CredentialsScope> SCOPES = Collections.unmodifiableSet(new LinkedHashSet<CredentialsScope>(Arrays.asList(CredentialsScope.GLOBAL, CredentialsScope.SYSTEM)));

        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SystemCredentialsProvider_ProviderImpl_DisplayName();
        }

        @Override
        public Set<CredentialsScope> getScopes(ModelObject object) {
            if (object instanceof Jenkins || object instanceof SystemCredentialsProvider) {
                return SCOPES;
            }
            return super.getScopes(object);
        }

        @Override
        public CredentialsStore getStore(@CheckForNull ModelObject object) {
            if (object == Jenkins.get()) {
                return SystemCredentialsProvider.getInstance().getStore();
            }
            return null;
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
            if (ACL.SYSTEM2.equals((Object)authentication)) {
                CredentialsMatcher matcher = Jenkins.get() == itemGroup ? CredentialsMatchers.always() : CredentialsMatchers.not(CredentialsMatchers.withScope(CredentialsScope.SYSTEM));
                return DomainCredentials.getCredentials(SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, matcher);
            }
            return new ArrayList();
        }

        @Override
        @NonNull
        public <C extends Credentials> List<C> getCredentialsInItem(@NonNull Class<C> type, @NonNull Item item, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
            if (ACL.SYSTEM2.equals((Object)authentication)) {
                return DomainCredentials.getCredentials(SystemCredentialsProvider.getInstance().getDomainCredentialsMap(), type, domainRequirements, CredentialsMatchers.not(CredentialsMatchers.withScope(CredentialsScope.SYSTEM)));
            }
            return new ArrayList();
        }

        @Override
        public String getIconClassName() {
            return "symbol-jenkins";
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SystemCredentialsProvider> {
        @NonNull
        public String getDisplayName() {
            return "";
        }
    }
}

