/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.matchers.AllOfMatcher;
import com.cloudbees.plugins.credentials.matchers.AnyOfMatcher;
import com.cloudbees.plugins.credentials.matchers.ConstantMatcher;
import com.cloudbees.plugins.credentials.matchers.IdMatcher;
import com.cloudbees.plugins.credentials.matchers.InstanceOfMatcher;
import com.cloudbees.plugins.credentials.matchers.NotMatcher;
import com.cloudbees.plugins.credentials.matchers.ScopeMatcher;
import com.cloudbees.plugins.credentials.matchers.UsernameMatcher;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CredentialsMatchers {
    private CredentialsMatchers() {
        throw new UnsupportedOperationException("Utility class");
    }

    @NonNull
    public static CredentialsMatcher always() {
        return new ConstantMatcher(true);
    }

    @NonNull
    public static CredentialsMatcher never() {
        return new ConstantMatcher(false);
    }

    @NonNull
    public static CredentialsMatcher not(@NonNull CredentialsMatcher matcher) {
        return new NotMatcher(matcher);
    }

    @NonNull
    public static CredentialsMatcher instanceOf(@NonNull Class clazz) {
        return new InstanceOfMatcher(clazz);
    }

    @NonNull
    public static CredentialsMatcher withId(@NonNull String id) {
        return new IdMatcher(id);
    }

    @NonNull
    public static CredentialsMatcher withScope(@NonNull CredentialsScope scope) {
        return new ScopeMatcher(scope);
    }

    @NonNull
    public static CredentialsMatcher withScopes(CredentialsScope ... scopes) {
        return new ScopeMatcher(scopes);
    }

    @NonNull
    public static CredentialsMatcher withScopes(@NonNull Collection<CredentialsScope> scopes) {
        return new ScopeMatcher(scopes);
    }

    @NonNull
    public static CredentialsMatcher withUsername(@NonNull String username) {
        return new UsernameMatcher(username);
    }

    @NonNull
    public static CredentialsMatcher allOf(CredentialsMatcher ... matchers) {
        return new AllOfMatcher(Arrays.asList(matchers));
    }

    @NonNull
    public static CredentialsMatcher anyOf(CredentialsMatcher ... matchers) {
        return new AnyOfMatcher(Arrays.asList(matchers));
    }

    @NonNull
    public static CredentialsMatcher both(@NonNull CredentialsMatcher matcher1, @NonNull CredentialsMatcher matcher2) {
        return new AllOfMatcher(Arrays.asList(matcher1, matcher2));
    }

    @NonNull
    public static CredentialsMatcher either(@NonNull CredentialsMatcher matcher1, @NonNull CredentialsMatcher matcher2) {
        return new AnyOfMatcher(Arrays.asList(matcher1, matcher2));
    }

    @NonNull
    public static CredentialsMatcher noneOf(CredentialsMatcher ... matchers) {
        return CredentialsMatchers.not(CredentialsMatchers.anyOf(matchers));
    }

    @NonNull
    public static <C extends Credentials> Collection<C> filter(@NonNull Collection<C> credentials, @NonNull CredentialsMatcher matcher) {
        return credentials.stream().filter(Objects::nonNull).filter(matcher::matches).collect(Collectors.toCollection(credentials instanceof Set ? LinkedHashSet::new : ArrayList::new));
    }

    @NonNull
    public static <C extends Credentials> Set<C> filter(@NonNull Set<C> credentials, @NonNull CredentialsMatcher matcher) {
        return credentials.stream().filter(Objects::nonNull).filter(matcher::matches).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @NonNull
    public static <C extends Credentials> List<C> filter(@NonNull List<C> credentials, @NonNull CredentialsMatcher matcher) {
        return credentials.stream().filter(Objects::nonNull).filter(matcher::matches).collect(Collectors.toList());
    }

    @NonNull
    public static <C extends Credentials> Iterable<C> filter(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher) {
        return StreamSupport.stream(credentials.spliterator(), false).filter(Objects::nonNull).filter(matcher::matches).collect(Collectors.toList());
    }

    @NonNull
    public static <C extends Credentials, V> Map<C, V> filterKeys(@NonNull Map<C, V> credentialMap, @NonNull CredentialsMatcher matcher) {
        LinkedHashMap<Credentials, V> result = new LinkedHashMap<Credentials, V>();
        for (Map.Entry<C, V> credential : credentialMap.entrySet()) {
            if (credential.getKey() == null || !matcher.matches((Credentials)credential.getKey())) continue;
            result.put((Credentials)credential.getKey(), credential.getValue());
        }
        return result;
    }

    @NonNull
    public static <C extends Credentials, K> Map<K, C> filterValues(@NonNull Map<K, C> credentialMap, @NonNull CredentialsMatcher matcher) {
        LinkedHashMap<K, Credentials> result = new LinkedHashMap<K, Credentials>();
        for (Map.Entry<K, C> credential : credentialMap.entrySet()) {
            if (credential.getValue() == null || !matcher.matches((Credentials)credential.getValue())) continue;
            result.put(credential.getKey(), (Credentials)credential.getValue());
        }
        return result;
    }

    @CheckForNull
    public static <C extends Credentials> C firstOrDefault(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher, @CheckForNull C defaultIfNone) {
        return (C)StreamSupport.stream(credentials.spliterator(), false).filter(matcher::matches).findFirst().orElse(defaultIfNone);
    }

    @CheckForNull
    public static <C extends Credentials> C firstOrNull(@NonNull Iterable<C> credentials, @NonNull CredentialsMatcher matcher) {
        return CredentialsMatchers.firstOrDefault(credentials, matcher, null);
    }
}

