/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.ResolveWith;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.tiger_types.Types;

public abstract class CredentialsResolver<F extends Credentials, T extends Credentials> {
    @NonNull
    private static final Logger LOGGER = Logger.getLogger(CredentialsResolver.class.getName());
    @NonNull
    private final Class<F> fromClass;
    @NonNull
    private final Class<T> toClass;

    protected CredentialsResolver(@NonNull Class<F> fromClass, @NonNull Class<T> toClass) {
        this.fromClass = Objects.requireNonNull(fromClass);
        this.toClass = Objects.requireNonNull(toClass);
    }

    protected CredentialsResolver(@NonNull Class<F> fromClass) {
        ParameterizedType pt;
        Class t;
        this.fromClass = Objects.requireNonNull(fromClass);
        Class<?> toClass = this.getClass().getEnclosingClass();
        if (toClass == null) {
            throw new AssertionError((Object)(String.valueOf(this.getClass()) + " doesn't have an outer class. Use the constructor that takes the Class object explicitly."));
        }
        this.toClass = toClass;
        Type bt = Types.getBaseClass(this.getClass(), Credentials.class);
        if (bt instanceof ParameterizedType && !(t = Types.erasure((Type)(pt = (ParameterizedType)bt).getActualTypeArguments()[0])).isAssignableFrom(fromClass)) {
            throw new AssertionError((Object)("Outer class " + String.valueOf(fromClass) + " of " + String.valueOf(this.getClass()) + " is not assignable to " + String.valueOf(t) + ". Perhaps wrong outer class?"));
        }
    }

    @CheckForNull
    public static <C extends Credentials> CredentialsResolver<Credentials, C> getResolver(@NonNull Class<C> clazz) {
        ResolveWith resolveWith = clazz.getAnnotation(ResolveWith.class);
        if (resolveWith != null) {
            try {
                CredentialsResolver resolver = resolveWith.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (Credentials.class.isAssignableFrom(resolver.getFromClass()) && clazz.isAssignableFrom(resolver.getToClass())) {
                    return resolver;
                }
                LOGGER.log(Level.SEVERE, "Resolver {0} for type {1} resolves to {2} which is not assignable to {1}", new Object[]{resolver.getClass(), clazz, resolver.getToClass()});
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                LOGGER.log(Level.WARNING, "Could not instantiate resolver: " + String.valueOf(resolveWith.value()), e);
                return null;
            }
        }
        return null;
    }

    @NonNull
    public Class<F> getFromClass() {
        return this.fromClass;
    }

    @NonNull
    public Class<T> getToClass() {
        return this.toClass;
    }

    @NonNull
    public T resolve(@NonNull F original) {
        Objects.requireNonNull(original);
        if (this.toClass.isInstance(original)) {
            return (T)((Credentials)this.toClass.cast(original));
        }
        return this.doResolve(original);
    }

    @NonNull
    public final List<T> resolve(@CheckForNull Collection<? extends F> originals) {
        ArrayList<T> result = new ArrayList<T>();
        if (originals != null) {
            for (Credentials original : originals) {
                if (original == null) continue;
                result.add(this.resolve(original));
            }
        }
        return result;
    }

    @NonNull
    protected abstract T doResolve(@NonNull F var1);
}

