/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsProviderFilterDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProviderTypeRestriction;
import com.cloudbees.plugins.credentials.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public abstract class CredentialsProviderFilter
extends AbstractDescribableImpl<CredentialsProviderFilter>
implements Serializable,
ExtensionPoint {
    private static final long serialVersionUID = 1L;

    public abstract boolean filter(CredentialsProvider var1);

    public CredentialsProviderFilterDescriptor getDescriptor() {
        return (CredentialsProviderFilterDescriptor)super.getDescriptor();
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    static Set<String> convertDescriptorClassNamesToIds(Set<String> idsOrDescriptorClassNames) {
        return idsOrDescriptorClassNames.stream().map(CredentialsProviderTypeRestriction::convertDescriptorClassNameToId).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static class Excludes
    extends CredentialsProviderFilter {
        private static final long serialVersionUID = 1L;
        @NonNull
        private Set<String> classNames;

        @DataBoundConstructor
        public Excludes(@CheckForNull List<String> classNames) {
            this.classNames = new LinkedHashSet<String>(Util.fixNull(classNames));
        }

        private Object readResolve() {
            this.classNames = Excludes.convertDescriptorClassNamesToIds(this.classNames);
            return this;
        }

        @Override
        public boolean filter(CredentialsProvider provider) {
            return !this.classNames.contains(provider.getId());
        }

        @NonNull
        public List<String> getClassNames() {
            return new ArrayList<String>(this.classNames);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Excludes excludes = (Excludes)o;
            return this.classNames.equals(excludes.classNames);
        }

        @Override
        public int hashCode() {
            return this.classNames.hashCode();
        }

        @Override
        public String toString() {
            return "Excludes{classes=" + String.valueOf(this.getClassNames()) + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsProviderFilterDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.CredentialsProviderFilter_Excludes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public List<CredentialsProvider> getProviderDescriptors() {
                return ExtensionList.lookup(CredentialsProvider.class);
            }
        }
    }

    public static class Includes
    extends CredentialsProviderFilter {
        private static final long serialVersionUID = 1L;
        @NonNull
        private Set<String> classNames;

        @DataBoundConstructor
        public Includes(@CheckForNull List<String> classNames) {
            this.classNames = new LinkedHashSet<String>(Util.fixNull(classNames));
        }

        private Object readResolve() {
            this.classNames = Includes.convertDescriptorClassNamesToIds(this.classNames);
            return this;
        }

        @Override
        public boolean filter(CredentialsProvider provider) {
            return this.classNames.contains(provider.getId());
        }

        @NonNull
        public List<String> getClassNames() {
            return new ArrayList<String>(this.classNames);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Includes includes = (Includes)o;
            return this.classNames.equals(includes.classNames);
        }

        @Override
        public int hashCode() {
            return this.classNames.hashCode();
        }

        @Override
        public String toString() {
            return "Includes{classes=" + String.valueOf(this.getClassNames()) + "}";
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsProviderFilterDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.CredentialsProviderFilter_Includes_DisplayName();
            }

            @Restricted(value={NoExternalUse.class})
            public List<CredentialsProvider> getProviderDescriptors() {
                return ExtensionList.lookup(CredentialsProvider.class);
            }
        }
    }

    public static class None
    extends CredentialsProviderFilter {
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public None() {
        }

        @Override
        public boolean filter(CredentialsProvider provider) {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        @Override
        public int hashCode() {
            return None.class.hashCode();
        }

        @Override
        public String toString() {
            return "None{}";
        }

        @Extension
        public static class DescriptorImpl
        extends CredentialsProviderFilterDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.CredentialsProviderFilter_None_DisplayName();
            }
        }
    }
}

