/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.prism.FilePermissionEnforcer;
import io.jenkins.plugins.prism.PermittedSourceCodeDirectory;
import io.jenkins.plugins.prism.PrismConfiguration;
import io.jenkins.plugins.prism.SourceDirectoryFilter;
import io.jenkins.plugins.util.RemoteResultWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;

public class PathResolver {
    public Map<String, String> resolvePaths(Set<String> relativePaths, Set<String> requestedSourceDirectories, FilePath workspace, FilteredLog log) throws InterruptedException {
        try {
            Set<String> permittedSourceDirectories = PrismConfiguration.getInstance().getSourceDirectories().stream().map(PermittedSourceCodeDirectory::getPath).collect(Collectors.toSet());
            AgentPathResolver resolver = new AgentPathResolver(relativePaths, permittedSourceDirectories, requestedSourceDirectories);
            RemoteResultWrapper agentLog = (RemoteResultWrapper)workspace.act((FilePath.FileCallable)resolver);
            log.merge((FilteredLog)agentLog);
            return (Map)((Object)agentLog.getResult());
        }
        catch (IOException exception) {
            log.logException((Exception)exception, "Can't resolve source files on agent", new Object[0]);
            return Collections.emptyMap();
        }
    }

    static class AgentPathResolver
    extends MasterToSlaveFileCallable<RemoteResultWrapper<HashMap<String, String>>> {
        private static final long serialVersionUID = 3966282357309568323L;
        private static final PathUtil PATH_UTIL = new PathUtil();
        private final HashSet<String> relativePaths;
        private final HashSet<String> permittedSourceDirectories;
        private final HashSet<String> requestedSourceDirectories;

        AgentPathResolver(Set<String> relativePaths, Set<String> permittedSourceDirectories, Set<String> requestedSourceDirectories) {
            this.relativePaths = new HashSet<String>(relativePaths);
            this.permittedSourceDirectories = new HashSet<String>(permittedSourceDirectories);
            this.requestedSourceDirectories = new HashSet<String>(requestedSourceDirectories);
        }

        public RemoteResultWrapper<HashMap<String, String>> invoke(File workspaceFile, VirtualChannel channel) {
            FilteredLog log = new FilteredLog("Errors while resolving source files on agent:");
            Set<String> sourceDirectories = this.filterSourceDirectories(workspaceFile, log);
            if (sourceDirectories.isEmpty()) {
                log.logInfo("Searching for source code files in root of workspace '%s'", new Object[]{workspaceFile});
            } else if (sourceDirectories.size() == 1) {
                log.logInfo("Searching for source code files in '%s'", new Object[]{sourceDirectories.iterator().next()});
            } else {
                log.logInfo("Searching for source code files in:", new Object[]{workspaceFile});
                sourceDirectories.forEach(dir -> log.logInfo("-> %s", new Object[]{dir}));
            }
            FilePath workspace = new FilePath(workspaceFile);
            Map<String, String> mapping = this.relativePaths.stream().map(path -> new AbstractMap.SimpleEntry<String, Optional<String>>((String)path, this.locateSource((String)path, workspace, sourceDirectories, log))).filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, entry -> (String)((Optional)entry.getValue()).get()));
            if (mapping.size() == this.relativePaths.size()) {
                log.logInfo("-> resolved absolute paths for all %d source files", new Object[]{mapping.size()});
            } else {
                log.logInfo("-> finished resolving of absolute paths (found: %d, not found: %d)", new Object[]{mapping.size(), this.relativePaths.size() - mapping.size()});
            }
            Map<String, String> changedFileMapping = mapping.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            RemoteResultWrapper result = new RemoteResultWrapper(new HashMap<String, String>(changedFileMapping), "Errors during source path resolving:");
            result.merge(log);
            return result;
        }

        private Set<String> filterSourceDirectories(File workspace, FilteredLog log) {
            SourceDirectoryFilter filter = new SourceDirectoryFilter();
            return filter.getPermittedSourceDirectories(workspace.getAbsolutePath(), this.permittedSourceDirectories, this.requestedSourceDirectories, log);
        }

        private Optional<String> locateSource(String relativePath, FilePath workspace, Set<String> sourceSearchDirectories, FilteredLog log) {
            try {
                FilePath absolutePath = new FilePath(new File(relativePath));
                if (absolutePath.exists()) {
                    return this.enforcePermissionFor(absolutePath, workspace, sourceSearchDirectories, log);
                }
                FilePath relativePathInWorkspace = workspace.child(relativePath);
                if (relativePathInWorkspace.exists()) {
                    return this.enforcePermissionFor(relativePathInWorkspace, workspace, sourceSearchDirectories, log);
                }
                for (String sourceFolder : sourceSearchDirectories) {
                    FilePath sourcePath = workspace.child(sourceFolder).child(relativePath);
                    if (!sourcePath.exists()) continue;
                    return this.enforcePermissionFor(sourcePath, workspace, sourceSearchDirectories, log);
                }
                log.logError("- Source file '%s' not found", new Object[]{relativePath});
            }
            catch (IOException | InterruptedException | InvalidPathException exception) {
                log.logException(exception, "No valid path in coverage node: '%s'", new Object[]{relativePath});
            }
            return Optional.empty();
        }

        private Optional<String> enforcePermissionFor(FilePath absolutePath, FilePath workspace, Set<String> sourceDirectories, FilteredLog log) {
            FilePermissionEnforcer enforcer = new FilePermissionEnforcer();
            String fileName = absolutePath.getRemote();
            if (enforcer.isInWorkspace(fileName, workspace, sourceDirectories)) {
                if (this.isWithinWorkspace(fileName, workspace)) {
                    return Optional.of(PATH_UTIL.getRelativePath(workspace.getRemote(), fileName));
                }
                return Optional.of(PATH_UTIL.getAbsolutePath(fileName));
            }
            log.logError("- Skipping resolving of file: %s (not part of workspace or permitted source code folders)", new Object[]{fileName});
            return Optional.empty();
        }

        private boolean isWithinWorkspace(String fileName, FilePath workspace) {
            String workspacePath = PATH_UTIL.getAbsolutePath(workspace.getRemote());
            return PATH_UTIL.getAbsolutePath(fileName).startsWith(workspacePath);
        }
    }
}

