/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import hudson.Functions;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.CoverageChangeTendency;
import io.jenkins.plugins.coverage.metrics.color.CoverageLevel;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.source.SourceCodeFacade;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.datatables.DetailedCell;
import io.jenkins.plugins.datatables.TableColumn;
import io.jenkins.plugins.datatables.TableConfiguration;
import io.jenkins.plugins.datatables.TableModel;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.CaseUtils;

class CoverageTableModel
extends TableModel {
    private static final int NO_COVERAGE_SORT = -1000;
    private static final SourceCodeFacade SOURCE_CODE_FACADE = new SourceCodeFacade();
    private static final int TABLE_COVERAGE_COLOR_ALPHA = 80;
    static final DetailedCell<Integer> NO_COVERAGE = new DetailedCell(Messages.Coverage_Not_Available(), (Object)-1000);
    private static final String SKIP_DELTA = "";
    private final ColorProvider colorProvider;
    private final Node root;
    private final RowRenderer renderer;
    private final String id;

    CoverageTableModel(String id, Node root, RowRenderer renderer, ColorProvider colors) {
        this.id = id;
        this.root = root;
        this.renderer = renderer;
        this.colorProvider = colors;
    }

    RowRenderer getRenderer() {
        return this.renderer;
    }

    public String getId() {
        return this.id;
    }

    public TableConfiguration getTableConfiguration() {
        TableConfiguration tableConfiguration = new TableConfiguration();
        tableConfiguration.responsive();
        if (this.getId().contains("inline")) {
            tableConfiguration.select(TableConfiguration.SelectStyle.SINGLE);
        }
        this.renderer.configureTable(tableConfiguration);
        return tableConfiguration;
    }

    public List<TableColumn> getColumns() {
        ArrayList<TableColumn> columns = new ArrayList<TableColumn>();
        TableColumn fileHash = new TableColumn.ColumnBuilder().withHeaderLabel("Hash").withDataPropertyKey("fileHash").withHeaderClass(TableColumn.ColumnCss.HIDDEN).build();
        columns.add(fileHash);
        TableColumn modified = new TableColumn.ColumnBuilder().withHeaderLabel("Modified").withDataPropertyKey("modified").withHeaderClass(TableColumn.ColumnCss.HIDDEN).build();
        columns.add(modified);
        TableColumn fileName = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Column_File()).withDataPropertyKey("fileName").withDetailedCell().withResponsivePriority(1).build();
        columns.add(fileName);
        TableColumn packageName = new TableColumn.ColumnBuilder().withHeaderLabel(Messages.Column_Package()).withDataPropertyKey("packageName").withResponsivePriority(50000).build();
        columns.add(packageName);
        this.configureValueColumn("lineCoverage", Metric.LINE, Messages.Column_LineCoverage(), Messages.Column_DeltaLineCoverage("\u0394"), columns);
        this.configureValueColumn("branchCoverage", Metric.BRANCH, Messages.Column_BranchCoverage(), Messages.Column_DeltaBranchCoverage("\u0394"), columns);
        this.configureValueColumn("mcdcPairCoverage", Metric.MCDC_PAIR, Messages.Column_MCDCPairs(), SKIP_DELTA, columns);
        this.configureValueColumn("functionCallCoverage", Metric.FUNCTION_CALL, Messages.Column_FunctionCall(), SKIP_DELTA, columns);
        this.configureValueColumn("mutationCoverage", Metric.MUTATION, Messages.Column_MutationCoverage(), Messages.Column_DeltaMutationCoverage("\u0394"), columns);
        this.configureValueColumn("testStrength", Metric.TEST_STRENGTH, Messages.Column_TestStrength(), Messages.Column_DeltaTestStrength("\u0394"), columns);
        EnumMap<Metric, Integer> entries = new EnumMap<Metric, Integer>(Map.of(Metric.LOC, 200, Metric.TESTS, 500, Metric.CYCLOMATIC_COMPLEXITY, 500, Metric.COGNITIVE_COMPLEXITY, 500, Metric.NPATH_COMPLEXITY, 500, Metric.NCSS, 500));
        for (Map.Entry<Metric, Integer> column : entries.entrySet()) {
            Metric metric = column.getKey();
            if (!this.root.containsMetric(metric)) continue;
            TableColumn tmp = new TableColumn.ColumnBuilder().withHeaderLabel(metric.getLabel()).withDataPropertyKey(CaseUtils.toCamelCase((String)metric.name(), (boolean)false, (char[])new char[]{'_'})).withResponsivePriority(column.getValue().intValue()).withType(TableColumn.ColumnType.NUMBER).build();
            columns.add(tmp);
        }
        return columns;
    }

    private void configureValueColumn(String key, Metric metric, String headerLabel, String deltaHeaderLabel, List<TableColumn> columns) {
        if (this.root.containsMetric(metric)) {
            TableColumn lineCoverage = new TableColumn.ColumnBuilder().withHeaderLabel(headerLabel).withDataPropertyKey(key).withDetailedCell().withType(TableColumn.ColumnType.NUMBER).withResponsivePriority(1).build();
            columns.add(lineCoverage);
            if (StringUtils.isNotEmpty((CharSequence)deltaHeaderLabel) && this.hasDelta(metric)) {
                TableColumn lineCoverageDelta = new TableColumn.ColumnBuilder().withHeaderLabel(deltaHeaderLabel).withDataPropertyKey(key + "Delta").withDetailedCell().withType(TableColumn.ColumnType.NUMBER).withResponsivePriority(2).build();
                columns.add(lineCoverageDelta);
            }
        }
    }

    private boolean hasDelta(Metric metric) {
        return this.root.getAllFileNodes().stream().anyMatch(f -> f.hasDelta(metric));
    }

    public List<Object> getRows() {
        Locale browserLocale = Functions.getCurrentLocale();
        return this.root.getAllFileNodes().stream().map(file -> new CoverageRow((FileNode)file, browserLocale, this.renderer, this.colorProvider)).collect(Collectors.toList());
    }

    protected Node getRoot() {
        return this.root;
    }

    protected ColorProvider getColorProvider() {
        return this.colorProvider;
    }

    static interface RowRenderer {
        public void configureTable(TableConfiguration var1);

        public String renderFileName(String var1, String var2);
    }

    static class CoverageRow {
        private static final String COVERAGE_COLUMN_OUTER = "coverage-cell-outer float-end";
        private static final String COVERAGE_COLUMN_INNER = "coverage-jenkins-cell-inner";
        private static final ElementFormatter FORMATTER = new ElementFormatter();
        private static final Value ZERO_LOC = new Value(Metric.LOC, 0);
        private static final Value ZERO_TESTS = new Value(Metric.TESTS, 0);
        private static final Value ZERO_CYCLOMATIC_COMPLEXITY = new Value(Metric.CYCLOMATIC_COMPLEXITY, 0);
        private static final Value ZERO_COGNITIVE_COMPLEXITY = new Value(Metric.COGNITIVE_COMPLEXITY, 0);
        private static final Value ZERO_NPATH_COMPLEXITY = new Value(Metric.NPATH_COMPLEXITY, 0);
        private static final Value ZERO_NCSS = new Value(Metric.NCSS, 0);
        private final FileNode file;
        private final Locale browserLocale;
        private final RowRenderer renderer;
        private final ColorProvider colorProvider;

        CoverageRow(FileNode file, Locale browserLocale, RowRenderer renderer, ColorProvider colors) {
            this.file = file;
            this.browserLocale = browserLocale;
            this.renderer = renderer;
            this.colorProvider = colors;
        }

        public String getFileHash() {
            return String.valueOf(this.file.getRelativePath().hashCode());
        }

        public boolean getModified() {
            return this.file.hasModifiedLines();
        }

        public DetailedCell<?> getFileName() {
            return new DetailedCell(this.renderer.renderFileName(this.file.getName(), this.file.getRelativePath()), (Object)this.file.getName());
        }

        public String getPackageName() {
            return this.file.getParentName();
        }

        public DetailedCell<?> getLineCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.LINE));
        }

        public DetailedCell<?> getBranchCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.BRANCH));
        }

        public DetailedCell<?> getMethodCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.METHOD));
        }

        public DetailedCell<?> getMcdcPairCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.MCDC_PAIR));
        }

        public DetailedCell<?> getFunctionCallCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.FUNCTION_CALL));
        }

        public DetailedCell<?> getMutationCoverage() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.MUTATION));
        }

        public DetailedCell<?> getTestStrength() {
            return this.createColoredCoverageColumn(this.getCoverageOfNode(Metric.TEST_STRENGTH));
        }

        Coverage getCoverageOfNode(Metric metric) {
            return (Coverage)this.file.getTypedValue(metric, (Value)Coverage.nullObject((Metric)metric));
        }

        public DetailedCell<?> getLineCoverageDelta() {
            return this.createColoredFileCoverageDeltaColumn(Metric.LINE);
        }

        public DetailedCell<?> getBranchCoverageDelta() {
            return this.createColoredFileCoverageDeltaColumn(Metric.BRANCH);
        }

        public DetailedCell<?> getMutationCoverageDelta() {
            return this.createColoredFileCoverageDeltaColumn(Metric.MUTATION);
        }

        public DetailedCell<?> getTestStrengthDelta() {
            return this.createColoredFileCoverageDeltaColumn(Metric.TEST_STRENGTH);
        }

        public int getLoc() {
            return this.file.getTypedValue(Metric.LOC, ZERO_LOC).asInteger();
        }

        public int getTests() {
            return this.file.getTypedValue(Metric.TESTS, ZERO_TESTS).asInteger();
        }

        public int getCyclomaticComplexity() {
            return this.file.getTypedValue(Metric.CYCLOMATIC_COMPLEXITY, ZERO_CYCLOMATIC_COMPLEXITY).asInteger();
        }

        public int getCognitiveComplexity() {
            return this.file.getTypedValue(Metric.COGNITIVE_COMPLEXITY, ZERO_COGNITIVE_COMPLEXITY).asInteger();
        }

        public int getNpathComplexity() {
            return this.file.getTypedValue(Metric.NPATH_COMPLEXITY, ZERO_NPATH_COMPLEXITY).asInteger();
        }

        public int getNcss() {
            return this.file.getTypedValue(Metric.NCSS, ZERO_NCSS).asInteger();
        }

        protected DetailedCell<?> createColoredCoverageColumn(Coverage coverage) {
            if (coverage.isSet()) {
                double percentage = coverage.asRounded();
                ColorProvider.DisplayColors colors = CoverageLevel.getDisplayColorsOfCoverageLevel(percentage, this.colorProvider);
                String cell = ((ContainerTag)TagCreator.div().withClasses(new String[]{COVERAGE_COLUMN_OUTER})).with((DomContent)((ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)((ContainerTag)TagCreator.div().withClasses(new String[]{COVERAGE_COLUMN_INNER})).withStyle("background-image: linear-gradient(90deg, %s %f%%, transparent %f%%);".formatted(colors.getFillColorAsRGBAHex(80), percentage, percentage))).attr("data-bs-toggle", (Object)"tooltip")).attr("data-bs-placement", (Object)"top")).withTitle(FORMATTER.formatAdditionalInformation((Value)coverage))).withText(FORMATTER.formatPercentage(coverage, this.browserLocale))).render();
                return new DetailedCell(cell, (Object)percentage);
            }
            return NO_COVERAGE;
        }

        protected DetailedCell<?> createColoredCoverageDeltaColumn(Metric metric, Value delta) {
            double percentage = delta.asRounded();
            ColorProvider.DisplayColors colors = CoverageChangeTendency.getDisplayColorsForTendency(percentage, this.colorProvider);
            String cell = ((ContainerTag)TagCreator.div().withClasses(new String[]{COVERAGE_COLUMN_OUTER})).with((DomContent)((ContainerTag)((ContainerTag)TagCreator.div().withClasses(new String[]{COVERAGE_COLUMN_INNER})).withStyle("background-color:%s;".formatted(colors.getFillColorAsRGBAHex(80)))).withText(FORMATTER.formatDelta(metric, delta, this.browserLocale))).render();
            return new DetailedCell(cell, (Object)percentage);
        }

        protected FileNode getFile() {
            return this.file;
        }

        private DetailedCell<?> createColoredFileCoverageDeltaColumn(Metric metric) {
            if (this.file.hasDelta(metric)) {
                return this.createColoredCoverageDeltaColumn(metric, this.file.getDelta(metric));
            }
            return NO_COVERAGE;
        }
    }

    static class InlineRowRenderer
    implements RowRenderer {
        InlineRowRenderer() {
        }

        @Override
        public void configureTable(TableConfiguration tableConfiguration) {
            tableConfiguration.select(TableConfiguration.SelectStyle.SINGLE);
        }

        @Override
        public String renderFileName(String fileName, String path) {
            return LinkedRowRenderer.renderWithToolTip(TagCreator.div().withText(fileName), path);
        }
    }

    static class LinkedRowRenderer
    implements RowRenderer {
        private final File buildFolder;
        private final String resultsId;

        LinkedRowRenderer(File buildFolder, String resultsId) {
            this.buildFolder = buildFolder;
            this.resultsId = resultsId;
        }

        @Override
        public void configureTable(TableConfiguration tableConfiguration) {
        }

        @Override
        public String renderFileName(String fileName, String path) {
            ContainerTag cell = SOURCE_CODE_FACADE.canRead(this.buildFolder, this.resultsId, path) ? ((ContainerTag)TagCreator.a().withHref(String.valueOf(path.hashCode()))).withText(fileName) : TagCreator.div().withText(fileName);
            return LinkedRowRenderer.renderWithToolTip(cell, path);
        }

        static String renderWithToolTip(ContainerTag cell, String path) {
            return ((ContainerTag)((ContainerTag)((ContainerTag)cell.attr("data-bs-toggle", (Object)"tooltip")).attr("data-bs-placement", (Object)"top")).withTitle(path)).render();
        }
    }
}

