/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.ContainerNode;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.coverage.metrics.steps.CoverageChecksPublisher;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.coverage.metrics.steps.CoverageReportScanner;
import io.jenkins.plugins.coverage.metrics.steps.CoverageReporter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTool;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.coverage.metrics.steps.PathResolver;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.AgentFileVisitor;
import io.jenkins.plugins.util.EnvironmentResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import io.jenkins.plugins.util.ResultHandler;
import io.jenkins.plugins.util.RunResultHandler;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CoverageRecorder
extends Recorder {
    static final String CHECKS_DEFAULT_NAME = "Code Coverage";
    static final String DEFAULT_ID = "coverage";
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private static final String ICON = "symbol-footsteps-outline plugin-ionicons-api";
    private List<CoverageTool> tools = new ArrayList<CoverageTool>();
    private List<CoverageQualityGate> qualityGates = new ArrayList<CoverageQualityGate>();
    private String id = "";
    private String name = "";
    private boolean skipPublishingChecks = false;
    private String checksName = "";
    private ChecksAnnotationScope checksAnnotationScope = ChecksAnnotationScope.MODIFIED_LINES;
    private boolean ignoreParsingErrors = false;
    private boolean failOnError = false;
    private boolean enabledForFailure = false;
    private boolean skipSymbolicLinks = false;
    private String scm = "";
    private String sourceCodeEncoding = "";
    private Set<SourceCodeDirectory> sourceDirectories = new HashSet<SourceCodeDirectory>();
    private SourceCodeRetention sourceCodeRetention = SourceCodeRetention.LAST_BUILD;

    @DataBoundConstructor
    public CoverageRecorder() {
    }

    @DataBoundSetter
    public void setTools(List<CoverageTool> tools) {
        this.tools = List.copyOf(tools);
    }

    public List<CoverageTool> getTools() {
        return this.tools;
    }

    @DataBoundSetter
    public void setQualityGates(List<CoverageQualityGate> qualityGates) {
        this.qualityGates = List.copyOf(qualityGates);
    }

    public List<CoverageQualityGate> getQualityGates() {
        return this.qualityGates;
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getActualId() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.id, (CharSequence)DEFAULT_ID);
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return StringUtils.defaultString((String)this.name);
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setChecksName(String checksName) {
        this.checksName = checksName;
    }

    public String getChecksName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.checksName, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)this.getName(), (CharSequence)CHECKS_DEFAULT_NAME)));
    }

    @DataBoundSetter
    public void setChecksAnnotationScope(ChecksAnnotationScope checksAnnotationScope) {
        this.checksAnnotationScope = checksAnnotationScope;
    }

    public ChecksAnnotationScope getChecksAnnotationScope() {
        return this.checksAnnotationScope;
    }

    @DataBoundSetter
    public void setSkipSymbolicLinks(boolean skipSymbolicLinks) {
        this.skipSymbolicLinks = skipSymbolicLinks;
    }

    public boolean isSkipSymbolicLinks() {
        return this.skipSymbolicLinks;
    }

    @DataBoundSetter
    public void setIgnoreParsingErrors(boolean ignoreParsingErrors) {
        this.ignoreParsingErrors = ignoreParsingErrors;
    }

    public boolean isIgnoreParsingErrors() {
        return this.ignoreParsingErrors;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setEnabledForFailure(boolean enabledForFailure) {
        this.enabledForFailure = enabledForFailure;
    }

    public boolean isEnabledForFailure() {
        return this.enabledForFailure;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<SourceCodeDirectory> sourceCodeDirectories) {
        this.sourceDirectories = Set.copyOf(sourceCodeDirectories);
    }

    public Set<SourceCodeDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    private Set<String> getSourceDirectoriesPaths() {
        Set<String> paths = this.sourceDirectories.stream().map(SourceCodeDirectory::getPath).collect(Collectors.toSet());
        paths.add("src/main/java");
        return paths;
    }

    @DataBoundSetter
    public void setSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.sourceCodeRetention = sourceCodeRetention;
    }

    public SourceCodeRetention getSourceCodeRetention() {
        return this.sourceCodeRetention;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("No workspace found for " + String.valueOf(build));
        }
        this.perform((Run<?, ?>)build, workspace, (TaskListener)listener, (ResultHandler)new RunResultHandler(build));
        return true;
    }

    void perform(Run<?, ?> run, FilePath workspace, TaskListener taskListener, ResultHandler resultHandler) throws InterruptedException {
        Result overallResult = run.getResult();
        LogHandler logHandler = new LogHandler(taskListener, "Coverage");
        if (this.enabledForFailure || overallResult == null || overallResult.isBetterOrEqualTo(Result.UNSTABLE)) {
            FilteredLog log = new FilteredLog("Errors while recording code coverage:");
            log.logInfo("Recording coverage results");
            FormValidation validation = VALIDATION_UTILITIES.validateId(this.getId());
            if (validation.kind != FormValidation.Kind.OK) {
                CoverageRecorder.failStage(resultHandler, logHandler, log, validation.getLocalizedMessage());
            }
            if (this.tools.isEmpty()) {
                CoverageRecorder.failStage(resultHandler, logHandler, log, "No tools defined that will record the coverage files");
            } else {
                this.perform(run, workspace, taskListener, resultHandler, log, logHandler);
            }
        } else {
            logHandler.log("Skipping execution of coverage recorder since overall result is '%s'", new Object[]{overallResult});
        }
    }

    private void perform(Run<?, ?> run, FilePath workspace, TaskListener taskListener, ResultHandler resultHandler, FilteredLog log, LogHandler logHandler) throws InterruptedException {
        Map<CoverageTool.Parser, List<ModuleNode>> results = this.recordCoverageResults(run, workspace, resultHandler, log, logHandler);
        Node aggregatedResult = this.aggregateResults(log, results);
        if (!aggregatedResult.isEmpty()) {
            CoverageReporter reporter = new CoverageReporter();
            Set sources = aggregatedResult.getSourceFolders();
            sources.addAll(this.getSourceDirectoriesPaths());
            this.resolveAbsolutePaths(aggregatedResult, workspace, sources, log);
            logHandler.log(log);
            CoverageBuildAction action = reporter.publishAction(this.getActualId(), this.getName(), this.getIcon(), aggregatedResult, run, workspace, taskListener, this.getQualityGates(), this.getScm(), this.getSourceCodeEncoding(), this.getSourceCodeRetention(), resultHandler, log);
            if (!this.skipPublishingChecks) {
                CoverageChecksPublisher checksPublisher = new CoverageChecksPublisher(action, aggregatedResult, this.getChecksName(), this.getChecksAnnotationScope());
                checksPublisher.publishCoverageReport(taskListener);
            }
        }
        logHandler.log(log);
    }

    private void resolveAbsolutePaths(Node rootNode, FilePath workspace, Set<String> sources, FilteredLog log) throws InterruptedException {
        log.logInfo("Resolving source code files...");
        Map<String, String> pathMapping = new PathResolver().resolvePaths(rootNode.getFiles(), sources, workspace, log);
        if (!pathMapping.isEmpty()) {
            log.logInfo("Making paths of " + pathMapping.size() + " source code files relative to workspace root...");
            TreeStringBuilder builder = new TreeStringBuilder();
            rootNode.getAllFileNodes().forEach(file -> {
                String relativePath = file.getRelativePath();
                if (pathMapping.containsKey(relativePath)) {
                    file.setRelativePath(builder.intern((String)pathMapping.get(relativePath)));
                }
            });
            builder.dedup();
        }
    }

    private String getIcon() {
        Set icons = this.tools.stream().map(CoverageTool::getParser).filter(parser -> parser.getParserType() != CoverageTool.ParserType.TEST).map(CoverageTool.Parser::getIcon).collect(Collectors.toSet());
        if (icons.size() == 1) {
            return (String)icons.iterator().next();
        }
        return ICON;
    }

    private static void failStage(ResultHandler resultHandler, LogHandler logHandler, FilteredLog log, String message) {
        log.logError(message);
        resultHandler.publishResult(Result.FAILURE, message);
        logHandler.log(log);
    }

    private Map<CoverageTool.Parser, List<ModuleNode>> recordCoverageResults(Run<?, ?> run, FilePath workspace, ResultHandler resultHandler, FilteredLog log, LogHandler logHandler) throws InterruptedException {
        EnumMap<CoverageTool.Parser, List<ModuleNode>> results = new EnumMap<CoverageTool.Parser, List<ModuleNode>>(CoverageTool.Parser.class);
        for (CoverageTool tool : this.tools) {
            String expandedPattern;
            CoverageTool.Parser parser = tool.getParser();
            log.logInfo("Creating parser for %s", new Object[]{tool.getDisplayName()});
            if (StringUtils.isBlank((CharSequence)tool.getPattern())) {
                log.logInfo("Using default pattern '%s' since user defined pattern is not set", new Object[]{parser.getDefaultPattern()});
            }
            if (!(expandedPattern = this.expandPattern(run, tool.getActualPattern())).equals(tool.getActualPattern())) {
                log.logInfo("Expanding pattern '%s' to '%s'", new Object[]{tool.getActualPattern(), expandedPattern});
            }
            try {
                AgentFileVisitor.FileVisitorResult result = (AgentFileVisitor.FileVisitorResult)workspace.act((FilePath.FileCallable)new CoverageReportScanner(parser, expandedPattern, "UTF-8", !this.isSkipSymbolicLinks(), this.ignoreErrors()));
                log.merge(result.getLog());
                List coverageResults = result.getResults();
                if (result.hasErrors()) {
                    if (this.isFailOnError()) {
                        String errorMessage = "Failing build due to some errors during recording of the coverage";
                        log.logInfo(errorMessage);
                        resultHandler.publishResult(Result.FAILURE, errorMessage);
                    } else {
                        log.logInfo("Ignore errors and continue processing");
                    }
                }
                results.put(tool.getParser(), coverageResults);
            }
            catch (IOException exception) {
                log.logException((Exception)exception, "Exception while parsing with tool " + String.valueOf(tool), new Object[0]);
            }
            logHandler.log(log);
        }
        return results;
    }

    private Node aggregateResults(FilteredLog log, Map<CoverageTool.Parser, List<ModuleNode>> results) {
        if (this.isEmpty(results)) {
            log.logError("No coverage results were found! Configuration error?");
            return new ModuleNode("Empty");
        }
        List testCases = results.entrySet().stream().filter(entry -> ((CoverageTool.Parser)((Object)((Object)entry.getKey()))).getParserType() == CoverageTool.ParserType.TEST).map(Map.Entry::getValue).flatMap(Collection::stream).map(Node::getAllClassNodes).flatMap(Collection::stream).collect(Collectors.toList());
        List coverageNodes = results.entrySet().stream().filter(entry -> ((CoverageTool.Parser)((Object)((Object)entry.getKey()))).getParserType() == CoverageTool.ParserType.COVERAGE).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        List metricsNodes = results.entrySet().stream().filter(entry -> ((CoverageTool.Parser)((Object)((Object)entry.getKey()))).getParserType() == CoverageTool.ParserType.METRICS).map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
        if (coverageNodes.isEmpty() && !testCases.isEmpty()) {
            log.logError("No coverage results were found, just tests! Configuration error?");
            ModuleNode tests = new ModuleNode("Tests");
            tests.addAllChildren(testCases);
            return tests;
        }
        Node coverageTree = Node.merge(coverageNodes);
        if (!metricsNodes.isEmpty()) {
            ContainerNode metrics = new ContainerNode("Metrics");
            metrics.addAllChildren(metricsNodes);
            coverageTree.addChild((Node)metrics);
        }
        if (!testCases.isEmpty()) {
            Set unmappedNodes = coverageTree.mergeTests(testCases);
            unmappedNodes.forEach(node -> this.mapTests((ClassNode)node, coverageTree));
        }
        return coverageTree;
    }

    private void mapTests(ClassNode classNode, Node coverageTree) {
        String normalizedPackageName = PackageNode.normalizePackageName((String)classNode.getPackageName());
        coverageTree.findPackage(normalizedPackageName).orElseGet(() -> this.createPackage(coverageTree, normalizedPackageName)).addChild((Node)classNode);
    }

    private PackageNode createPackage(Node coverageTree, String normalizedPackageName) {
        PackageNode packageNode = new PackageNode(normalizedPackageName);
        coverageTree.addChild((Node)packageNode);
        return packageNode;
    }

    private boolean isEmpty(Map<CoverageTool.Parser, List<ModuleNode>> results) {
        return results.values().stream().mapToInt(Collection::size).sum() == 0;
    }

    private CoverageParser.ProcessingMode ignoreErrors() {
        return this.isIgnoreParsingErrors() ? CoverageParser.ProcessingMode.IGNORE_ERRORS : CoverageParser.ProcessingMode.FAIL_FAST;
    }

    private String expandPattern(Run<?, ?> run, String actualPattern) {
        try {
            EnvironmentResolver environmentResolver = new EnvironmentResolver();
            return environmentResolver.expandEnvironmentVariables(run.getEnvironment(TaskListener.NULL), actualPattern);
        }
        catch (IOException | InterruptedException ignore) {
            return actualPattern;
        }
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    public static enum ChecksAnnotationScope {
        SKIP,
        MODIFIED_LINES,
        ALL_LINES;


        static ListBoxModel fillItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(Messages.ChecksAnnotationScope_Skip(), SKIP.name());
            items.add(Messages.ChecksAnnotationScope_ModifiedLines(), MODIFIED_LINES.name());
            items.add(Messages.ChecksAnnotationScope_AllLines(), ALL_LINES.name());
            return items;
        }
    }

    @Extension
    @Symbol(value={"recordCoverage"})
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_Name();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @POST
        public ListBoxModel doFillSourceCodeRetentionItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return SourceCodeRetention.fillItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillChecksAnnotationScopeItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return ChecksAnnotationScope.fillItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ComboBoxModel doFillSourceCodeEncodingItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return VALIDATION_UTILITIES.getAllCharsets();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckSourceCodeEncoding(@AncestorInPath BuildableItem project, @QueryParameter String sourceCodeEncoding) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateCharset(sourceCodeEncoding);
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }
    }
}

