/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Value;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.util.QualityGate;
import io.jenkins.plugins.util.QualityGateEvaluator;
import io.jenkins.plugins.util.QualityGateResult;
import io.jenkins.plugins.util.QualityGateStatus;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;

class CoverageQualityGateEvaluator
extends QualityGateEvaluator<CoverageQualityGate> {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private final CoverageStatistics statistics;

    CoverageQualityGateEvaluator(Collection<? extends CoverageQualityGate> qualityGates, CoverageStatistics statistics) {
        super(qualityGates);
        this.statistics = statistics;
    }

    protected void evaluate(CoverageQualityGate qualityGate, QualityGateResult result) {
        Baseline baseline = qualityGate.getBaseline();
        Optional<Value> possibleValue = this.statistics.getValue(baseline, qualityGate.getMetric());
        if (possibleValue.isPresent()) {
            Value actualValue = possibleValue.get();
            QualityGateStatus status = actualValue.isOutOfValidRange(qualityGate.getThreshold()) ? qualityGate.getStatus() : QualityGateStatus.PASSED;
            result.add((QualityGate)qualityGate, status, FORMATTER.format(possibleValue.get(), Locale.ENGLISH));
        } else {
            result.add((QualityGate)qualityGate, QualityGateStatus.INACTIVE, "n/a");
        }
    }
}

