/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.restapi;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Node;
import io.jenkins.plugins.coverage.metrics.restapi.FileWithModifiedLines;
import io.jenkins.plugins.coverage.metrics.restapi.LineCoverageType;
import io.jenkins.plugins.coverage.metrics.restapi.ModifiedLinesBlock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
class ModifiedLinesCoverageApi {
    private final List<FileWithModifiedLines> filesWithModifiedLines;

    ModifiedLinesCoverageApi(Node node) {
        this.filesWithModifiedLines = this.createListOfFilesWithModifiedLines(node);
    }

    @Exported(inline=true, name="files")
    public List<FileWithModifiedLines> getFilesWithModifiedLines() {
        return this.filesWithModifiedLines;
    }

    private List<FileWithModifiedLines> createListOfFilesWithModifiedLines(Node node) {
        ArrayList<FileWithModifiedLines> result = new ArrayList<FileWithModifiedLines>();
        for (FileNode fileNode : node.filterByModifiedLines().getAllFileNodes()) {
            ArrayList<Integer> modifiedLines = new ArrayList<Integer>(fileNode.getModifiedLines());
            List<Integer> modifiedLinesWithoutCoverage = modifiedLines.stream().filter(line -> !fileNode.getLinesWithCoverage().contains(line)).collect(Collectors.toList());
            List<Integer> missedLines = this.filterByModifiedLines(modifiedLines, fileNode.getMissedLines());
            List<Integer> partiallyCoveredLines = this.filterByModifiedLines(modifiedLines, fileNode.getPartiallyCoveredLines().keySet());
            List<Integer> coveredLines = fileNode.getLinesWithCoverage().stream().filter(line -> fileNode.getMissedOfLine(line.intValue()) == 0).filter(modifiedLines::contains).collect(Collectors.toList());
            TreeSet<ModifiedLinesBlock> modifiedLinesBlocks = new TreeSet<ModifiedLinesBlock>();
            modifiedLinesBlocks.addAll(this.calculateModifiedLineBlocks(coveredLines, modifiedLinesWithoutCoverage, LineCoverageType.COVERED));
            modifiedLinesBlocks.addAll(this.calculateModifiedLineBlocks(missedLines, modifiedLinesWithoutCoverage, LineCoverageType.MISSED));
            modifiedLinesBlocks.addAll(this.calculateModifiedLineBlocks(partiallyCoveredLines, modifiedLinesWithoutCoverage, LineCoverageType.PARTIALLY_COVERED));
            FileWithModifiedLines changedFile = new FileWithModifiedLines(fileNode.getRelativePath(), modifiedLinesBlocks);
            result.add(changedFile);
        }
        return result;
    }

    private List<Integer> filterByModifiedLines(Collection<Integer> modifiedLines, Collection<Integer> lines) {
        return lines.stream().filter(modifiedLines::contains).collect(Collectors.toList());
    }

    private List<ModifiedLinesBlock> calculateModifiedLineBlocks(List<Integer> modifiedLines, List<Integer> modifiedLinesWithoutCoverage, LineCoverageType type) {
        int start;
        ArrayList<ModifiedLinesBlock> modifiedLinesBlocks = new ArrayList<ModifiedLinesBlock>();
        if (modifiedLines.isEmpty()) {
            return modifiedLinesBlocks;
        }
        int last = start = modifiedLines.get(0).intValue();
        if (modifiedLines.size() > 1) {
            for (int line : modifiedLines.subList(1, modifiedLines.size())) {
                if (line > last + 1 && this.hasAnyLinesWithCoverageBetween(last, line, modifiedLinesWithoutCoverage)) {
                    ModifiedLinesBlock modifiedLinesBlock = new ModifiedLinesBlock(start, last, type);
                    modifiedLinesBlocks.add(modifiedLinesBlock);
                    start = line;
                }
                last = line;
            }
        }
        ModifiedLinesBlock modifiedLinesBlock = new ModifiedLinesBlock(start, last, type);
        modifiedLinesBlocks.add(modifiedLinesBlock);
        return modifiedLinesBlocks;
    }

    private boolean hasAnyLinesWithCoverageBetween(int start, int end, List<Integer> modifiedLinesWithoutCoverage) {
        return IntStream.range(start + 1, end).anyMatch(line -> !modifiedLinesWithoutCoverage.contains(line));
    }
}

