/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Functions;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.ListBoxModel;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.CoverageAppearanceConfiguration;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class CoverageMetricColumn
extends ListViewColumn {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private String columnName;
    private Metric metric;
    private Baseline baseline = Baseline.PROJECT;

    @DataBoundConstructor
    public CoverageMetricColumn() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    CoverageMetricColumn(JenkinsFacade facade) {
        this.columnName = CoverageMetricColumn.getConfiguration(facade).getDefaultName();
        this.metric = CoverageMetricColumn.getConfiguration(facade).getDefaultMetric();
    }

    public ElementFormatter getFormatter() {
        return FORMATTER;
    }

    @DataBoundSetter
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    @DataBoundSetter
    public void setBaseline(Baseline baseline) {
        this.baseline = baseline;
    }

    public Baseline getBaseline() {
        return this.baseline;
    }

    @DataBoundSetter
    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public List<Value> getAllValues(Job<?, ?> job) {
        return CoverageMetricColumn.findAction(job).map(a -> a.getAllValues(this.baseline)).orElse(List.of());
    }

    public String formatMetric(Value value) {
        return FORMATTER.getDisplayName(value.getMetric());
    }

    public String formatValue(Value value) {
        return FORMATTER.formatValue(value);
    }

    public String getCoverageText(Job<?, ?> job) {
        Optional<Value> coverageValue = this.getCoverageValue(job);
        if (coverageValue.isPresent()) {
            return FORMATTER.format(coverageValue.get(), Functions.getCurrentLocale());
        }
        return Messages.Coverage_Not_Available();
    }

    public Optional<Value> getCoverageValue(Job<?, ?> job) {
        return CoverageMetricColumn.findAction(job).flatMap(action -> action.getStatistics().getValue(this.getBaseline(), this.metric));
    }

    private static Optional<CoverageBuildAction> findAction(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        if (lastCompletedBuild == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((CoverageBuildAction)lastCompletedBuild.getAction(CoverageBuildAction.class));
    }

    public ColorProvider.DisplayColors getDisplayColors(Job<?, ?> job, Optional<? extends Value> coverage) {
        if (coverage.isPresent() && this.hasCoverageAction(job)) {
            return FORMATTER.getDisplayColors(this.baseline, coverage.get());
        }
        return ColorProvider.DEFAULT_COLOR;
    }

    public String getRelativeCoverageUrl(Job<?, ?> job) {
        if (this.hasCoverageAction(job)) {
            CoverageBuildAction action = (CoverageBuildAction)job.getLastCompletedBuild().getAction(CoverageBuildAction.class);
            return action.getUrlName() + "/" + this.baseline.getUrl();
        }
        return "";
    }

    public String getBackgroundColorFillPercentage(String percentage) {
        return FORMATTER.getBackgroundColorFillPercentage(percentage);
    }

    private boolean hasCoverageAction(Job<?, ?> job) {
        Run lastCompletedBuild = job.getLastCompletedBuild();
        return lastCompletedBuild != null && !lastCompletedBuild.getActions(CoverageBuildAction.class).isEmpty();
    }

    private static CoverageAppearanceConfiguration getConfiguration(JenkinsFacade jenkins) {
        DescriptorExtensionList configurations = jenkins.getDescriptorsFor(GlobalConfiguration.class);
        return Objects.requireNonNull((CoverageAppearanceConfiguration)((Object)configurations.get(CoverageAppearanceConfiguration.class)));
    }

    @Extension(optional=true)
    @Symbol(value={"coverageTotalsColumn"})
    public static class CoverageMetricColumnDescriptor
    extends ListViewColumnDescriptor {
        private final JenkinsFacade jenkins;

        public CoverageMetricColumnDescriptor() {
            this(new JenkinsFacade());
        }

        @VisibleForTesting
        CoverageMetricColumnDescriptor(JenkinsFacade jenkins) {
            this.jenkins = jenkins;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Coverage_Column();
        }

        public boolean shownByDefault() {
            return CoverageMetricColumn.getConfiguration(this.jenkins).isEnableColumnByDefault();
        }

        @POST
        public ListBoxModel doFillMetricItems() {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                return FORMATTER.getMetricItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillBaselineItems() {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                return FORMATTER.getBaselineItems();
            }
            return new ListBoxModel();
        }
    }
}

