/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.util.FilteredLog;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.forensics.delta.Delta;
import io.jenkins.plugins.forensics.delta.DeltaCalculatorFactory;
import io.jenkins.plugins.forensics.delta.FileChanges;
import io.jenkins.plugins.forensics.delta.FileEditType;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;

class CodeDeltaCalculator {
    static final String AMBIGUOUS_PATHS_ERROR = "Failed to map SCM paths with coverage report paths due to ambiguous fully qualified names";
    static final String AMBIGUOUS_OLD_PATHS_ERROR = "Failed to map SCM paths from the reference with coverage report paths from the reference due to ambiguous fully qualified names";
    static final String CODE_DELTA_TO_COVERAGE_DATA_MISMATCH_ERROR_TEMPLATE = "Unexpected behavior detected when comparing coverage data with the code delta - there are ambiguous paths when comparing new with former file paths: ";
    static final String EMPTY_OLD_PATHS_WARNING = "File renaming has been detected for files which have not been part of the reference coverage report. These files are skipped when calculating the coverage deltas:";
    private final Run<?, ?> build;
    private final FilePath workspace;
    private final TaskListener listener;
    private final String scm;

    CodeDeltaCalculator(Run<?, ?> build, FilePath workspace, TaskListener listener, String scm) {
        this.build = build;
        this.workspace = workspace;
        this.listener = listener;
        this.scm = scm;
    }

    public Optional<Delta> calculateCodeDeltaToReference(Run<?, ?> referenceBuild, FilteredLog log) {
        return DeltaCalculatorFactory.findDeltaCalculator((String)this.scm, this.build, (FilePath)this.workspace, (TaskListener)this.listener, (FilteredLog)log).calculateDelta(this.build, referenceBuild, log);
    }

    public Set<FileChanges> getCoverageRelevantChanges(Delta delta) {
        return delta.getFileChangesMap().values().stream().filter(fileChange -> fileChange.getFileEditType() == FileEditType.MODIFY || fileChange.getFileEditType() == FileEditType.ADD || fileChange.getFileEditType() == FileEditType.RENAME).collect(Collectors.toSet());
    }

    public Map<String, FileChanges> mapScmChangesToReportPaths(Set<FileChanges> changes, Node root, FilteredLog log) throws IllegalStateException {
        HashSet<String> reportPaths = new HashSet<String>(root.getFiles());
        Set<String> scmPaths = changes.stream().map(FileChanges::getFileName).collect(Collectors.toSet());
        Map<String, String> pathMapping = this.getScmToReportPathMapping(scmPaths, reportPaths);
        this.verifyScmToReportPathMapping(pathMapping, log);
        return changes.stream().filter(change -> reportPaths.contains(pathMapping.get(change.getFileName()))).collect(Collectors.toMap(fileChange -> (String)pathMapping.get(fileChange.getFileName()), Function.identity()));
    }

    public Map<String, String> createOldPathMapping(Node root, Node referenceRoot, Map<String, FileChanges> changes, FilteredLog log) throws IllegalStateException {
        HashSet<String> oldReportPaths = new HashSet<String>(referenceRoot.getFiles());
        Map<String, String> oldPathMapping = changes.entrySet().stream().filter(entry -> FileEditType.RENAME == ((FileChanges)entry.getValue()).getFileEditType()).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((FileChanges)entry.getValue()).getOldFileName()));
        Map<String, String> oldScmToOldReportPathMapping = this.getScmToReportPathMapping(oldPathMapping.values(), oldReportPaths);
        Set<String> newReportPathsWithRename = oldPathMapping.keySet();
        oldPathMapping.forEach((reportPath, oldScmPath) -> {
            String oldReportPath = (String)oldScmToOldReportPathMapping.get(oldScmPath);
            oldPathMapping.replace((String)reportPath, oldReportPath);
        });
        if (!newReportPathsWithRename.equals(oldPathMapping.keySet())) {
            throw new IllegalStateException(AMBIGUOUS_OLD_PATHS_ERROR);
        }
        root.getFiles().stream().filter(file -> !oldPathMapping.containsKey(file) && oldReportPaths.contains(file)).forEach(file -> oldPathMapping.put((String)file, (String)file));
        this.removeMissingReferences(oldPathMapping, log);
        CodeDeltaCalculator.verifyOldPathMapping(oldPathMapping, log);
        return oldPathMapping;
    }

    private Map<String, String> getScmToReportPathMapping(Collection<String> scmPaths, Collection<String> reportPaths) {
        HashMap<String, String> pathMapping = new HashMap<String, String>();
        for (String scmPath : scmPaths) {
            reportPaths.stream().filter(scmPath::endsWith).max(Comparator.comparingInt(String::length)).map(match -> {
                pathMapping.put(scmPath, (String)match);
                return match;
            }).orElseGet(() -> pathMapping.put(scmPath, ""));
        }
        return pathMapping;
    }

    private void verifyScmToReportPathMapping(Map<String, String> pathMapping, FilteredLog log) throws IllegalStateException {
        List notEmptyValues = pathMapping.values().stream().filter(path -> !path.isEmpty()).collect(Collectors.toList());
        if (notEmptyValues.size() != new HashSet(notEmptyValues).size()) {
            throw new IllegalStateException(AMBIGUOUS_PATHS_ERROR);
        }
        log.logInfo("Successfully mapped SCM paths to coverage report paths");
    }

    private void removeMissingReferences(Map<String, String> oldPathMapping, FilteredLog log) {
        Set<String> pathsWithEmptyReferences = oldPathMapping.entrySet().stream().filter(entry -> ((String)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (!pathsWithEmptyReferences.isEmpty()) {
            pathsWithEmptyReferences.forEach(oldPathMapping::remove);
            String skippedFiles = pathsWithEmptyReferences.stream().limit(20L).collect(Collectors.joining("," + System.lineSeparator()));
            log.logInfo(EMPTY_OLD_PATHS_WARNING + System.lineSeparator() + skippedFiles);
        }
    }

    static void verifyOldPathMapping(Map<String, String> oldPathMapping, FilteredLog log) throws IllegalStateException {
        Set duplicates = (Set)((StreamEx)StreamEx.of(oldPathMapping.values()).distinct(2L)).collect(Collectors.toSet());
        Map<String, String> duplicateEntries = oldPathMapping.entrySet().stream().filter(entry -> duplicates.contains(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (!duplicates.isEmpty()) {
            String mismatches = duplicateEntries.entrySet().stream().limit(20L).map(entry -> "new: '%s' - former: '%s'".formatted(entry.getKey(), entry.getValue())).collect(Collectors.joining("," + System.lineSeparator()));
            String errorMessage = CODE_DELTA_TO_COVERAGE_DATA_MISMATCH_ERROR_TEMPLATE + System.lineSeparator() + mismatches;
            throw new IllegalStateException(errorMessage);
        }
        log.logInfo("Successfully verified that the coverage data matches with the code delta");
    }
}

