/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import io.jenkins.plugins.prism.Sanitizer;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.text.StringEscapeUtils;

class CoverageSourcePrinter
implements Serializable {
    private static final long serialVersionUID = -6044649044983631852L;
    static final Sanitizer SANITIZER = new Sanitizer();
    static final String MODIFIED = "modified";
    static final String UNDEFINED = "noCover";
    static final String NO_COVERAGE = "coverNone";
    static final String FULL_COVERAGE = "coverFull";
    static final String PARTIAL_COVERAGE = "coverPart";
    static final String NBSP = "&nbsp;";
    private final String path;
    private final int[] linesToPaint;
    private final int[] coveredPerLine;
    private final int[] missedPerLine;
    private final TreeSet<Integer> modifiedLines;

    CoverageSourcePrinter(FileNode file) {
        this.path = file.getRelativePath();
        this.linesToPaint = file.getLinesWithCoverage().stream().mapToInt(i -> i).toArray();
        this.coveredPerLine = file.getCoveredCounters();
        this.missedPerLine = file.getMissedCounters();
        this.modifiedLines = new TreeSet(file.getModifiedLines());
    }

    public String renderLine(int line, String sourceCode) {
        boolean isPainted = this.isPainted(line);
        return ((ContainerTag)((ContainerTag)TagCreator.tr().withClasses(new String[]{isPainted ? this.getColorClass(line) : UNDEFINED, this.getModifiedClass(line)})).condAttr(isPainted, "data-html-tooltip", isPainted ? this.getTooltip(line) : "")).with(new DomContent[]{((ContainerTag)TagCreator.td().withClass("line")).with((DomContent)((ContainerTag)TagCreator.a().withName(String.valueOf(line))).withText(String.valueOf(line))), ((ContainerTag)TagCreator.td().withClass("hits")).with((DomContent)(isPainted ? TagCreator.text((String)this.getSummaryColumn(line)) : TagCreator.text((String)""))), ((ContainerTag)TagCreator.td().withClass("code")).with((DomContent)TagCreator.rawHtml((String)SANITIZER.render(this.cleanupCode(sourceCode))))}).render();
    }

    protected String cleanupCode(String content) {
        String escaped = StringEscapeUtils.escapeHtml4((String)content);
        return escaped.replace("\n", "").replace("\r", "").replace(" ", NBSP).replace("\t", NBSP.repeat(8));
    }

    final int size() {
        return this.linesToPaint.length;
    }

    String getModifiedClass(int line) {
        return this.isModified(line) ? MODIFIED : "";
    }

    public String getColorClass(int line) {
        if (this.getCovered(line) == 0) {
            return NO_COVERAGE;
        }
        if (this.getMissed(line) == 0) {
            return FULL_COVERAGE;
        }
        return PARTIAL_COVERAGE;
    }

    public String getTooltip(int line) {
        int missed;
        int covered = this.getCovered(line);
        if (covered + (missed = this.getMissed(line)) > 1) {
            if (missed == 0) {
                return "All branches covered";
            }
            if (covered == 0) {
                return "No branches covered";
            }
            return "Partially covered, branch coverage: %d/%d".formatted(covered, covered + missed);
        }
        if (covered == 1) {
            return "Covered at least once";
        }
        return "Not covered";
    }

    public String getSummaryColumn(int line) {
        int missed;
        int covered = this.getCovered(line);
        if (covered + (missed = this.getMissed(line)) > 1) {
            return "%d/%d".formatted(covered, covered + missed);
        }
        return String.valueOf(covered);
    }

    public final String getPath() {
        return this.path;
    }

    public boolean isPainted(int line) {
        return this.findIndexOfLine(line) >= 0;
    }

    private boolean isModified(int line) {
        return this.modifiedLines.contains(line);
    }

    int findIndexOfLine(int line) {
        return Arrays.binarySearch(this.linesToPaint, line);
    }

    public int getCovered(int line) {
        return this.getCounter(line, this.coveredPerLine);
    }

    public int getMissed(int line) {
        return this.getCounter(line, this.missedPerLine);
    }

    int getCounter(int line, int ... counters) {
        int index = this.findIndexOfLine(line);
        if (index >= 0) {
            return counters[index];
        }
        return 0;
    }

    public String getColumnHeader() {
        return "";
    }
}

