/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.ClassNode;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.TestCase;
import edu.hm.hafner.coverage.parser.AbstractTestParser;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class NunitParser
extends AbstractTestParser {
    private static final long serialVersionUID = -5468593789018138107L;
    private static final QName TEST_SUITE = new QName("test-suite");
    private static final QName TEST_CASE = new QName("test-case");
    private static final QName RESULT = new QName("result");
    private static final String PASSED = "Passed";
    private static final String FAILED = "Failed";
    private static final String SKIPPED = "Skipped";

    public NunitParser() {
        this(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public NunitParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode, TEST_SUITE, TEST_CASE);
    }

    @Override
    TestCase readTestCase(XMLEventReader reader, StartElement testCaseElement, String suiteName, ModuleNode root, String fileName) throws XMLStreamException {
        TestCase.TestCaseBuilder builder = new TestCase.TestCaseBuilder();
        builder.withTestName(NunitParser.getOptionalValueOf(testCaseElement, NAME).orElse(this.createId()));
        this.readStatus(testCaseElement, builder);
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && this.isFailure(event)) {
                this.readFailure(reader, builder);
                continue;
            }
            if (!event.isEndElement() || !TEST_CASE.equals(event.asEndElement().getName())) continue;
            String className = NunitParser.getOptionalValueOf(testCaseElement, CLASS_NAME).orElse(suiteName);
            builder.withClassName(className);
            PackageNode packageNode = root.findOrCreatePackageNode("-");
            ClassNode classNode = packageNode.findOrCreateClassNode(className);
            classNode.addTestCase(builder.build());
            return builder.build();
        }
        throw NunitParser.createEofException(fileName);
    }

    private void readStatus(StartElement testCaseElement, TestCase.TestCaseBuilder builder) {
        String status;
        switch (status = NunitParser.getValueOf(testCaseElement, RESULT)) {
            case "Passed": {
                builder.withStatus(TestCase.TestResult.PASSED);
                break;
            }
            case "Failed": {
                builder.withStatus(TestCase.TestResult.FAILED);
                break;
            }
            default: {
                builder.withStatus(TestCase.TestResult.SKIPPED);
            }
        }
    }

    private boolean isFailure(XMLEvent event) {
        return FAILURE.equals(this.getElementName(event));
    }

    private void readFailure(XMLEventReader reader, TestCase.TestCaseBuilder builder) throws XMLStreamException {
        builder.withFailure();
        StringBuilder aggregatedContent = new StringBuilder();
        while (true) {
            XMLEvent event;
            if ((event = reader.nextEvent()).isCharacters()) {
                aggregatedContent.append(event.asCharacters().getData());
                continue;
            }
            if (event.isEndElement() && this.isFailure(event)) {
                return;
            }
            if (event.isEndElement() && event.asEndElement().getName().equals(MESSAGE)) break;
        }
        builder.withDescription(aggregatedContent.toString());
    }
}

