/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.PathUtil;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class GoCovParser
extends CoverageParser {
    private static final long serialVersionUID = -4511292826873362408L;
    private static final PathUtil PATH_UTIL = new PathUtil();
    private static final Pattern LINE_PATTERN = Pattern.compile("(?:(?<org>[^/\\\\:]+\\.[^/\\\\:]+)[/\\\\])?(?<project>[^/\\\\:]+)[/\\\\](?<module>[^/\\\\:]+)[/\\\\](?<package>.*[/\\\\]?.*)[/\\\\](?<file>[^/\\\\:]+):(?<lineStart>\\d+)\\.(?<columnStart>\\d+),(?<lineEnd>\\d+)\\.(?<columnEnd>\\d+)\\s*(?<statements>\\d+)\\s*(?<executions>\\d+)");

    public GoCovParser() {
        super(CoverageParser.ProcessingMode.FAIL_FAST);
    }

    public GoCovParser(CoverageParser.ProcessingMode processingMode) {
        super(processingMode);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected ModuleNode parseReport(Reader reader, String reportFile, FilteredLog log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getOrganisation(Matcher matcher) {
        String org = matcher.group("org");
        if (org == null) {
            return "";
        }
        return org + "/";
    }

    private void buildCoverages(Set<FileNode> files, Map<String, Integer> coveredInstructionsPerFile, Map<String, Integer> missedInstructionsPerFile, Map<String, List<LineRange>> coveredRangesPerFile, Map<String, List<LineRange>> missedRangesPerFile) {
        Coverage.CoverageBuilder lineBuilder = new Coverage.CoverageBuilder().withMetric(Metric.LINE);
        Coverage.CoverageBuilder instructionBuilder = new Coverage.CoverageBuilder().withMetric(Metric.INSTRUCTION);
        for (FileNode file : files) {
            Integer coveredInstructions = coveredInstructionsPerFile.getOrDefault(file.getId(), 0);
            Integer missedInstructions = missedInstructionsPerFile.getOrDefault(file.getId(), 0);
            file.addValue(instructionBuilder.withCovered(coveredInstructions).withMissed(missedInstructions).build());
            List<Integer> coveredLines = this.getLines(coveredRangesPerFile, file);
            List<Integer> missedLines = this.getLines(missedRangesPerFile, file);
            missedLines.removeAll(coveredLines);
            file.addValue(lineBuilder.withCovered(coveredLines.size()).withMissed(missedLines.size()).build());
            coveredLines.forEach(line -> file.addCounters((int)line, 1, 0));
            missedLines.forEach(line -> file.addCounters((int)line, 0, 1));
        }
    }

    private List<Integer> getLines(Map<String, List<LineRange>> coveredRangesPerFile, FileNode file) {
        return coveredRangesPerFile.getOrDefault(file.getId(), List.of()).stream().map(LineRange::getLines).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private void merge(Map<String, List<LineRange>> map, String key, LineRange value) {
        map.merge(key, new ArrayList<LineRange>(List.of(value)), (? super V oldValue, ? super V newValue) -> {
            oldValue.addAll(newValue);
            return oldValue;
        });
    }

    private int asInt(Matcher matcher, String group) {
        try {
            return Integer.parseInt(matcher.group(group));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    private static /* synthetic */ boolean lambda$parseReport$0(String moduleName, ModuleNode m) {
        return m.getName().equals(moduleName);
    }
}

