/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage.parser;

import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.coverage.Rate;
import edu.hm.hafner.coverage.TestCase;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.SecureXmlParserFactory;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

abstract class AbstractTestParser
extends CoverageParser {
    private static final long serialVersionUID = 3771784159977766871L;
    static final QName NAME = new QName("name");
    static final QName FAILURE = new QName("failure");
    static final QName MESSAGE = new QName("message");
    static final QName CLASS_NAME = new QName("classname");
    private final QName testSuite;
    private final QName testCase;

    AbstractTestParser(CoverageParser.ProcessingMode processingMode, QName testSuite, QName testCase) {
        super(processingMode);
        this.testSuite = testSuite;
        this.testCase = testCase;
    }

    QName getTestCase() {
        return this.testCase;
    }

    QName getTestSuite() {
        return this.testSuite;
    }

    @Override
    protected ModuleNode parseReport(Reader reader, String fileName, FilteredLog log) {
        try {
            XMLEventReader eventReader = new SecureXmlParserFactory().createXmlEventReader(reader);
            ModuleNode root = new ModuleNode(fileName);
            List<TestCase> tests = this.readTestCases(eventReader, root, fileName);
            this.handleEmptyResults(fileName, log, tests.isEmpty());
            return root;
        }
        catch (XMLStreamException exception) {
            throw new CoverageParser.ParsingException(exception);
        }
    }

    private List<TestCase> readTestCases(XMLEventReader eventReader, ModuleNode root, String fileName) throws XMLStreamException {
        long passed;
        String suiteName = "-";
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            if (event.isStartElement() && this.getTestSuite().equals(event.asStartElement().getName())) {
                suiteName = AbstractTestParser.getOptionalValueOf(event.asStartElement(), NAME).orElse("-");
                continue;
            }
            if (!event.isStartElement() || !this.getTestCase().equals(event.asStartElement().getName())) continue;
            tests.add(this.readTestCase(eventReader, event.asStartElement(), suiteName, root, fileName));
        }
        long failed = tests.stream().filter(TestCase::isFailed).count();
        long total = failed + (passed = tests.stream().filter(TestCase::isPassed).count());
        if (total > 0L) {
            root.addValue(new Rate(Metric.TEST_SUCCESS_RATE, passed, total));
        }
        return tests;
    }

    abstract TestCase readTestCase(XMLEventReader var1, StartElement var2, String var3, ModuleNode var4, String var5) throws XMLStreamException;

    protected String createId() {
        return UUID.randomUUID().toString();
    }
}

