/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

public enum MutationStatus {
    KILLED(LineCoverage.COVERED),
    SURVIVED(LineCoverage.COVERED),
    NO_COVERAGE(LineCoverage.MISSED),
    NON_VIABLE(LineCoverage.UNKNOWN),
    TIMED_OUT(LineCoverage.COVERED),
    MEMORY_ERROR(LineCoverage.UNKNOWN),
    RUN_ERROR(LineCoverage.UNKNOWN);

    private final LineCoverage lineCoverage;

    private MutationStatus(LineCoverage lineCoverage) {
        this.lineCoverage = lineCoverage;
    }

    public boolean isDetected() {
        return this == KILLED;
    }

    public boolean isNotDetected() {
        return this == SURVIVED || this == NO_COVERAGE;
    }

    public boolean isCovered() {
        return this.lineCoverage == LineCoverage.COVERED;
    }

    public boolean isMissed() {
        return this.lineCoverage == LineCoverage.MISSED;
    }

    static enum LineCoverage {
        COVERED,
        MISSED,
        UNKNOWN;

    }
}

