/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.CoverageMetricsValues;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Mutation;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.LineRange;
import edu.hm.hafner.util.LineRangeList;
import edu.hm.hafner.util.TreeString;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public final class FileNode
extends Node {
    private static final long serialVersionUID = -3795695377267542624L;
    private static final int UNSET = -1;
    private final NavigableMap<Integer, Integer> coveredPerLine = new TreeMap<Integer, Integer>();
    private final NavigableMap<Integer, Integer> missedPerLine = new TreeMap<Integer, Integer>();
    private NavigableMap<Integer, Integer> mcdcPairCoveredPerLine = new TreeMap<Integer, Integer>();
    private NavigableMap<Integer, Integer> mcdcPairMissedPerLine = new TreeMap<Integer, Integer>();
    private NavigableMap<Integer, Integer> functionCallCoveredPerLine = new TreeMap<Integer, Integer>();
    private NavigableMap<Integer, Integer> functionCallMissedPerLine = new TreeMap<Integer, Integer>();
    private final List<Mutation> mutations = new ArrayList<Mutation>();
    private final SortedSet<Integer> modifiedLines = new TreeSet<Integer>();
    private final NavigableMap<Integer, Integer> indirectCoverageChanges = new TreeMap<Integer, Integer>();
    private final NavigableMap<Metric, Value> coverageDelta = new TreeMap<Metric, Value>();
    private TreeString relativePath;

    public FileNode(String name, TreeString relativePath) {
        super(Metric.FILE, name);
        this.relativePath = relativePath;
    }

    public FileNode(String name, String relativePath) {
        this(name, TreeString.valueOf((String)relativePath));
    }

    @Override
    public String getId() {
        return this.relativePath.toString() + this.getName();
    }

    @SuppressFBWarnings(value={"RCN"}, justification="Value might be null in old serializations")
    private Object readResolve() {
        if (this.relativePath == null) {
            this.relativePath = TreeString.valueOf((String)"");
        }
        if (this.mcdcPairCoveredPerLine == null) {
            this.mcdcPairCoveredPerLine = new TreeMap<Integer, Integer>();
        }
        if (this.mcdcPairMissedPerLine == null) {
            this.mcdcPairMissedPerLine = new TreeMap<Integer, Integer>();
        }
        if (this.functionCallCoveredPerLine == null) {
            this.functionCallCoveredPerLine = new TreeMap<Integer, Integer>();
        }
        if (this.functionCallMissedPerLine == null) {
            this.functionCallMissedPerLine = new TreeMap<Integer, Integer>();
        }
        return this;
    }

    @Override
    public FileNode copy() {
        FileNode copy = new FileNode(this.getName(), this.relativePath);
        copy.coveredPerLine.putAll(this.coveredPerLine);
        copy.missedPerLine.putAll(this.missedPerLine);
        copy.mcdcPairCoveredPerLine.putAll(this.mcdcPairCoveredPerLine);
        copy.mcdcPairMissedPerLine.putAll(this.mcdcPairMissedPerLine);
        copy.functionCallCoveredPerLine.putAll(this.functionCallCoveredPerLine);
        copy.functionCallMissedPerLine.putAll(this.functionCallMissedPerLine);
        copy.modifiedLines.addAll(this.modifiedLines);
        copy.mutations.addAll(this.mutations);
        copy.indirectCoverageChanges.putAll(this.indirectCoverageChanges);
        copy.coverageDelta.putAll(this.coverageDelta);
        return copy;
    }

    @Override
    protected boolean filterByRelativePath(Collection<String> fileNames) {
        return fileNames.contains(this.getRelativePath());
    }

    @Override
    public boolean matches(Metric searchMetric, String searchName) {
        return this.getMetric() == searchMetric && (this.getRelativePath().equals(searchName) || this.getName().equals(searchName));
    }

    @Override
    public boolean matches(Metric searchMetric, int searchNameHashCode) {
        return this.getMetric() == searchMetric && (this.getRelativePath().hashCode() == searchNameHashCode || this.getName().hashCode() == searchNameHashCode);
    }

    @Override
    protected void mergeNode(Node other) {
        Ensure.that((Object)other, (Object[])new Object[0]).isInstanceOf(FileNode.class, new Class[0]);
        this.removeValues();
        this.removeChildren();
        this.mergeCounters((FileNode)other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void mergeCounters(FileNode otherFile) {
        TreeSet lines = new TreeSet();
        lines.addAll(this.coveredPerLine.keySet());
        lines.addAll(this.mcdcPairCoveredPerLine.keySet());
        lines.addAll(this.functionCallCoveredPerLine.keySet());
        lines.addAll(otherFile.coveredPerLine.keySet());
        Coverage.CoverageBuilder lineCoverage = new Coverage.CoverageBuilder().withMetric(Metric.LINE).withCovered(0).withMissed(0);
        Coverage.CoverageBuilder branchCoverage = new Coverage.CoverageBuilder().withMetric(Metric.BRANCH).withCovered(0).withMissed(0);
        Coverage.CoverageBuilder mcdcPairCoverage = new Coverage.CoverageBuilder().withMetric(Metric.MCDC_PAIR).withCovered(0).withMissed(0);
        Coverage.CoverageBuilder functionCallCoverage = new Coverage.CoverageBuilder().withMetric(Metric.FUNCTION_CALL).withCovered(0).withMissed(0);
        Iterator iterator = lines.iterator();
        while (iterator.hasNext()) {
            int line = (Integer)iterator.next();
            CoverageMetricsValues left = new CoverageMetricsValues(this.coveredPerLine.getOrDefault(line, 0), this.missedPerLine.getOrDefault(line, 0));
            CoverageMetricsValues leftMcdcPair = new CoverageMetricsValues(this.mcdcPairCoveredPerLine.getOrDefault(line, 0), this.mcdcPairMissedPerLine.getOrDefault(line, 0));
            CoverageMetricsValues leftFunctionCall = new CoverageMetricsValues(this.functionCallCoveredPerLine.getOrDefault(line, 0), this.functionCallMissedPerLine.getOrDefault(line, 0));
            CoverageMetricsValues right = new CoverageMetricsValues(otherFile.coveredPerLine.getOrDefault(line, 0), otherFile.missedPerLine.getOrDefault(line, 0));
            CoverageMetricsValues rightMcdcPair = new CoverageMetricsValues(otherFile.mcdcPairCoveredPerLine.getOrDefault(line, 0), otherFile.mcdcPairMissedPerLine.getOrDefault(line, 0));
            CoverageMetricsValues rightFunctionCall = new CoverageMetricsValues(otherFile.functionCallCoveredPerLine.getOrDefault(line, 0), otherFile.functionCallMissedPerLine.getOrDefault(line, 0));
            if (left.totalsNotEqual(right)) {
                if (!left.noMissing() && !right.noMissing()) throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot merge coverage information for line %d in %s", line, this));
                left.setCoveredFromMax(right);
                left.clearMissed();
                left.setTotalFromCovered();
            } else if (leftMcdcPair.totalsNotEqual(rightMcdcPair) || leftFunctionCall.totalsNotEqual(rightFunctionCall)) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot merge coverage information for line %d in %s", line, this));
            }
            if (left.hasAnyInfo()) {
                this.mergeLeftRight(line, left.getCovered(), left.getMissed(), right.getCovered(), right.getMissed(), this.coveredPerLine, this.missedPerLine);
                this.updateLineCoverage(line, lineCoverage);
                this.updateBranchCoverage(line, branchCoverage);
                continue;
            }
            if (leftMcdcPair.hasAnyInfo()) {
                this.mergeLeftRight(line, leftMcdcPair.getCovered(), leftMcdcPair.getMissed(), rightMcdcPair.getCovered(), rightMcdcPair.getMissed(), this.mcdcPairCoveredPerLine, this.mcdcPairMissedPerLine);
                this.updateMcdcPairCoverage(line, mcdcPairCoverage);
                continue;
            }
            if (leftFunctionCall.hasAnyInfo()) {
                this.mergeLeftRight(line, leftFunctionCall.getCovered(), leftFunctionCall.getMissed(), rightFunctionCall.getCovered(), rightFunctionCall.getMissed(), this.functionCallCoveredPerLine, this.functionCallMissedPerLine);
                this.updateFunctionCallCoverage(line, functionCallCoverage);
                continue;
            }
            this.coveredPerLine.put(line, left.getMaxCovered(right));
            this.missedPerLine.put(line, left.getMinMissed(right));
            this.updateLineCoverage(line, lineCoverage);
        }
        this.setValues(lineCoverage, branchCoverage, mcdcPairCoverage, functionCallCoverage);
        otherFile.getValues().stream().filter(value -> value.getMetric() == Metric.CYCLOMATIC_COMPLEXITY).forEach(this::addValue);
    }

    private void setValues(Coverage.CoverageBuilder lineCoverage, Coverage.CoverageBuilder branchCoverage, Coverage.CoverageBuilder mcdcPairCoverage, Coverage.CoverageBuilder functionCallCoverage) {
        Coverage functionCallValue;
        Coverage mcdcPairValue;
        Coverage branchValue;
        Coverage lineValue = lineCoverage.build();
        if (lineValue.isSet()) {
            this.addValue(lineValue);
        }
        if ((branchValue = branchCoverage.build()).isSet()) {
            this.addValue(branchValue);
        }
        if ((mcdcPairValue = mcdcPairCoverage.build()).isSet()) {
            this.addValue(mcdcPairValue);
        }
        if ((functionCallValue = functionCallCoverage.build()).isSet()) {
            this.addValue(functionCallValue);
        }
    }

    private void mergeLeftRight(int line, int leftCovered, int leftMissed, int rightCovered, int rightMissed, NavigableMap<Integer, Integer> localCoveredPerLine, NavigableMap<Integer, Integer> localMissedPerLine) {
        if (leftCovered > rightCovered) {
            localCoveredPerLine.put(line, leftCovered);
            localMissedPerLine.put(line, leftMissed);
        } else {
            localCoveredPerLine.put(line, rightCovered);
            localMissedPerLine.put(line, rightMissed);
        }
    }

    private void updateBranchCoverage(int line, Coverage.CoverageBuilder branchCoverage) {
        branchCoverage.incrementCovered(this.getCoveredOfLine(line));
        branchCoverage.incrementMissed(this.getMissedOfLine(line));
    }

    private void updateMcdcPairCoverage(int line, Coverage.CoverageBuilder mcdcPairCoverage) {
        mcdcPairCoverage.incrementCovered(this.getMcdcPairCoveredOfLine(line));
        mcdcPairCoverage.incrementMissed(this.getMcdcPairMissedOfLine(line));
    }

    private void updateFunctionCallCoverage(int line, Coverage.CoverageBuilder functionCallCoverage) {
        functionCallCoverage.incrementCovered(this.getFunctionCallCoveredOfLine(line));
        functionCallCoverage.incrementMissed(this.getFunctionCallMissedOfLine(line));
    }

    private void updateLineCoverage(int line, Coverage.CoverageBuilder lineCoverage) {
        if (this.getCoveredOfLine(line) > 0) {
            lineCoverage.incrementCovered();
        } else {
            lineCoverage.incrementMissed();
        }
    }

    public SortedSet<Integer> getModifiedLines() {
        return new TreeSet<Integer>(this.modifiedLines);
    }

    @Override
    public boolean hasModifiedLines() {
        return !this.modifiedLines.isEmpty();
    }

    public boolean hasModifiedLine(int line) {
        return this.modifiedLines.contains(line);
    }

    public void addModifiedLines(int ... lines) {
        for (int line : lines) {
            this.modifiedLines.add(line);
        }
    }

    @Override
    protected Optional<Node> filterTreeByModifiedLines() {
        if (!this.hasCoveredAndModifiedLines()) {
            return Optional.empty();
        }
        FileNode copy = new FileNode(this.getName(), this.relativePath);
        copy.modifiedLines.addAll(this.modifiedLines);
        this.filterLineAndBranchCoverage(copy);
        this.filterMutations(copy);
        return Optional.of(copy);
    }

    private void filterLineAndBranchCoverage(FileNode copy) {
        Coverage lineCoverage = Coverage.nullObject(Metric.LINE);
        Coverage.CoverageBuilder lineBuilder = new Coverage.CoverageBuilder().withMetric(Metric.LINE);
        Coverage branchCoverage = Coverage.nullObject(Metric.BRANCH);
        Coverage.CoverageBuilder branchBuilder = new Coverage.CoverageBuilder().withMetric(Metric.BRANCH);
        Iterator iterator = this.getCoveredAndModifiedLines().iterator();
        while (iterator.hasNext()) {
            int line = (Integer)iterator.next();
            Integer covered = this.coveredPerLine.getOrDefault(line, 0);
            Integer missed = this.missedPerLine.getOrDefault(line, 0);
            int total = covered + missed;
            copy.addCounters(line, covered, missed);
            if (total == 0) {
                throw new IllegalArgumentException("No coverage for line " + line);
            }
            if (total == 1) {
                lineCoverage = lineCoverage.add(lineBuilder.withCovered(covered).withMissed(missed).build());
                continue;
            }
            int branchCoveredAsLine = covered > 0 ? 1 : 0;
            lineCoverage = lineCoverage.add(lineBuilder.withCovered(branchCoveredAsLine).withMissed(1 - branchCoveredAsLine).build());
            branchCoverage = branchCoverage.add(branchBuilder.withCovered(covered).withMissed(missed).build());
        }
        this.addLineAndBranchCoverage(copy, lineCoverage, branchCoverage);
    }

    private void filterMutations(FileNode copy) {
        this.mutations.stream().filter(mutation -> this.modifiedLines.contains(mutation.getLine())).forEach(copy::addMutation);
        if (!copy.mutations.isEmpty()) {
            Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder().withMetric(Metric.MUTATION).withMissed(0).withCovered(0);
            copy.mutations.stream().filter(Mutation::isDetected).forEach(mutation -> builder.incrementCovered());
            copy.mutations.stream().filter(Predicate.not(Mutation::isDetected)).forEach(mutation -> builder.incrementMissed());
            copy.addValue(builder.build());
        }
    }

    @Override
    protected Optional<Node> filterTreeByModifiedFiles() {
        return this.hasCoveredAndModifiedLines() ? Optional.of(this.copyTree()) : Optional.empty();
    }

    private void addLineAndBranchCoverage(FileNode copy, Coverage lineCoverage, Coverage branchCoverage) {
        if (lineCoverage.isSet()) {
            copy.addValue(lineCoverage);
        }
        if (branchCoverage.isSet()) {
            copy.addValue(branchCoverage);
        }
    }

    @Override
    protected Optional<Node> filterTreeByIndirectChanges() {
        if (!this.hasIndirectCoverageChanges()) {
            return Optional.empty();
        }
        FileNode copy = new FileNode(this.getName(), this.relativePath);
        Coverage lineCoverage = Coverage.nullObject(Metric.LINE);
        Coverage branchCoverage = Coverage.nullObject(Metric.BRANCH);
        for (Map.Entry<Integer, Integer> change : this.getIndirectCoverageChanges().entrySet()) {
            int delta = change.getValue();
            Coverage currentCoverage = this.getBranchCoverage(change.getKey());
            if (!currentCoverage.isSet()) {
                currentCoverage = this.getLineCoverage(change.getKey());
            }
            Coverage.CoverageBuilder builder = new Coverage.CoverageBuilder();
            if (delta > 0) {
                if (delta == currentCoverage.getCovered()) {
                    builder.withMetric(Metric.LINE).withCovered(1).withMissed(0);
                    lineCoverage = lineCoverage.add(builder.build());
                }
                if (currentCoverage.getTotal() <= 1) continue;
                builder.withMetric(Metric.BRANCH).withCovered(delta).withMissed(0);
                branchCoverage = branchCoverage.add(builder.build());
                continue;
            }
            if (delta >= 0) continue;
            if (currentCoverage.getCovered() == 0) {
                builder.withMetric(Metric.LINE).withCovered(0).withMissed(1);
                lineCoverage = lineCoverage.add(builder.build());
            }
            if (currentCoverage.getTotal() <= 1) continue;
            builder.withMetric(Metric.BRANCH).withCovered(0).withMissed(Math.abs(delta));
            branchCoverage = branchCoverage.add(builder.build());
        }
        this.addLineAndBranchCoverage(copy, lineCoverage, branchCoverage);
        return Optional.of(copy);
    }

    public void addIndirectCoverageChange(int line, int hitsDelta) {
        this.indirectCoverageChanges.put(line, hitsDelta);
    }

    public SortedMap<Integer, Integer> getIndirectCoverageChanges() {
        return new TreeMap<Integer, Integer>((SortedMap<Integer, Integer>)this.indirectCoverageChanges);
    }

    public NavigableSet<Integer> getLinesWithCoverage() {
        return new TreeSet<Integer>(this.coveredPerLine.keySet());
    }

    public boolean hasCoverageForLine(int line) {
        return this.coveredPerLine.containsKey(line) || this.mcdcPairCoveredPerLine.containsKey(line) || this.functionCallCoveredPerLine.containsKey(line);
    }

    private Coverage getLineCoverage(int line) {
        if (this.hasCoverageForLine(line)) {
            int covered = this.getCoveredOfLine(line) > 0 ? 1 : 0;
            return new Coverage.CoverageBuilder().withMetric(Metric.LINE).withCovered(covered).withMissed(1 - covered).build();
        }
        return Coverage.nullObject(Metric.LINE);
    }

    private Coverage getBranchCoverage(int line) {
        int missed;
        int covered;
        if (this.hasCoverageForLine(line) && (covered = this.getCoveredOfLine(line)) + (missed = this.getMissedOfLine(line)) > 1) {
            return new Coverage.CoverageBuilder().withMetric(Metric.BRANCH).withCovered(covered).withMissed(missed).build();
        }
        return Coverage.nullObject(Metric.BRANCH);
    }

    @Override
    public Set<String> getFiles() {
        return Set.of(this.getRelativePath());
    }

    public boolean hasIndirectCoverageChanges() {
        return !this.indirectCoverageChanges.isEmpty();
    }

    public void computeDelta(FileNode referenceFile) {
        NavigableMap<Metric, Value> referenceCoverage = referenceFile.getMetricsDistribution();
        this.getMetricsDistribution().forEach((metric, value) -> {
            if (referenceCoverage.containsKey(metric)) {
                this.coverageDelta.put((Metric)((Object)metric), value.subtract((Value)referenceCoverage.get(metric)));
            }
        });
    }

    public Value getDelta(Metric metric) {
        return this.coverageDelta.getOrDefault((Object)metric, Value.nullObject(metric));
    }

    public boolean hasDelta(Metric metric) {
        return this.coverageDelta.containsKey((Object)metric);
    }

    public SortedSet<Integer> getCoveredAndModifiedLines() {
        NavigableSet<Integer> coveredDelta = this.getLinesWithCoverage();
        coveredDelta.retainAll(this.getModifiedLines());
        return coveredDelta;
    }

    public boolean hasCoveredAndModifiedLines() {
        return !this.getCoveredAndModifiedLines().isEmpty();
    }

    @CanIgnoreReturnValue
    public FileNode addCounters(int lineNumber, int covered, int missed) {
        this.coveredPerLine.put(lineNumber, covered);
        this.missedPerLine.put(lineNumber, missed);
        return this;
    }

    @CanIgnoreReturnValue
    public FileNode addMcdcPairCounters(int lineNumber, int covered, int missed) {
        this.mcdcPairCoveredPerLine.put(lineNumber, covered);
        this.mcdcPairMissedPerLine.put(lineNumber, missed);
        return this;
    }

    @CanIgnoreReturnValue
    public FileNode addFunctionCallCounters(int lineNumber, int covered, int missed) {
        this.functionCallCoveredPerLine.put(lineNumber, covered);
        this.functionCallMissedPerLine.put(lineNumber, missed);
        return this;
    }

    public int[] getCoveredCounters() {
        return this.entriesToArray(this.coveredPerLine);
    }

    public int[] getMissedCounters() {
        return this.entriesToArray(this.missedPerLine);
    }

    public int[] getMcdcPairCoveredCounters() {
        return this.entriesToArray(this.mcdcPairCoveredPerLine);
    }

    public int[] getMcdcPairMissedCounters() {
        return this.entriesToArray(this.mcdcPairMissedPerLine);
    }

    public int[] getFunctionCallCoveredCounters() {
        return this.entriesToArray(this.functionCallCoveredPerLine);
    }

    public int[] getFunctionCallMissedCounters() {
        return this.entriesToArray(this.functionCallMissedPerLine);
    }

    public int getCoveredOfLine(int line) {
        return this.coveredPerLine.getOrDefault(line, 0);
    }

    private int getMcdcPairCoveredOfLine(int line) {
        return this.mcdcPairCoveredPerLine.getOrDefault(line, 0);
    }

    private int getFunctionCallCoveredOfLine(int line) {
        return this.functionCallCoveredPerLine.getOrDefault(line, 0);
    }

    private int getMcdcPairMissedOfLine(int line) {
        return this.mcdcPairMissedPerLine.getOrDefault(line, 0);
    }

    private int getFunctionCallMissedOfLine(int line) {
        return this.functionCallMissedPerLine.getOrDefault(line, 0);
    }

    public int getMissedOfLine(int line) {
        return this.missedPerLine.getOrDefault(line, 0);
    }

    private int[] entriesToArray(NavigableMap<Integer, Integer> map) {
        return map.values().stream().mapToInt(i -> i).toArray();
    }

    public NavigableSet<Integer> getMissedLines() {
        return this.filterLines(line -> this.getCoveredOfLine((int)line) == 0);
    }

    public NavigableSet<Integer> getCoveredLines() {
        return this.filterLines(line -> this.getCoveredOfLine((int)line) != 0);
    }

    private NavigableSet<Integer> filterLines(Predicate<Integer> predicate) {
        return this.coveredPerLine.keySet().stream().filter(predicate).collect(Collectors.toCollection(TreeSet::new));
    }

    public LineRangeList getMissedLineRanges() {
        LineRangeList lineRanges = new LineRangeList();
        NavigableSet<Integer> missedLines = this.getMissedLines();
        if (missedLines.isEmpty()) {
            return lineRanges;
        }
        if (missedLines.size() == 1) {
            lineRanges.add(new LineRange(((Integer)missedLines.first()).intValue()));
            return lineRanges;
        }
        List<Integer> lines = List.copyOf(this.getLinesWithCoverage());
        int start = -1;
        int end = -1;
        for (int line : lines) {
            if (this.getCoveredOfLine(line) == 0) {
                if (start == -1) {
                    start = line;
                }
                end = line;
                continue;
            }
            if (start == -1) continue;
            lineRanges.add(new LineRange(start, end));
            start = -1;
        }
        if (start != -1) {
            lineRanges.add(new LineRange(start, end));
        }
        return lineRanges;
    }

    public NavigableMap<Integer, List<Mutation>> getSurvivedMutationsPerLine() {
        return this.createMapOfMutations(Mutation::hasSurvived);
    }

    public NavigableMap<Integer, List<Mutation>> getMutationsPerLine() {
        return this.createMapOfMutations(b -> true);
    }

    private NavigableMap<Integer, List<Mutation>> createMapOfMutations(Predicate<Mutation> predicate) {
        return this.getMutations().stream().filter(predicate).collect(Collectors.groupingBy(Mutation::getLine, TreeMap::new, Collectors.toList()));
    }

    public NavigableMap<Integer, Integer> getPartiallyCoveredLines() {
        return this.getLinesWithCoverage().stream().filter(line -> this.getCoveredOfLine((int)line) > 0).filter(line -> this.getMissedOfLine((int)line) > 0).collect(Collectors.toMap(line -> line, this.missedPerLine::get, (a, b) -> a, TreeMap::new));
    }

    public NavigableMap<Integer, Integer> getCounters() {
        return Collections.unmodifiableNavigableMap(this.coveredPerLine);
    }

    public void addMutation(Mutation mutation) {
        this.mutations.add(mutation);
    }

    @Override
    public List<Mutation> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }

    public String getRelativePath() {
        return this.relativePath.toString();
    }

    @SuppressFBWarnings(value={"SECWF"}, justification="False positive")
    public String getFileName() {
        return FilenameUtils.getName((String)this.getRelativePath());
    }

    public void setRelativePath(TreeString relativePath) {
        this.relativePath = relativePath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileNode fileNode = (FileNode)o;
        return Objects.equals(this.coveredPerLine, fileNode.coveredPerLine) && Objects.equals(this.missedPerLine, fileNode.missedPerLine) && Objects.equals(this.mcdcPairCoveredPerLine, fileNode.mcdcPairCoveredPerLine) && Objects.equals(this.mcdcPairMissedPerLine, fileNode.mcdcPairMissedPerLine) && Objects.equals(this.functionCallCoveredPerLine, fileNode.functionCallCoveredPerLine) && Objects.equals(this.functionCallMissedPerLine, fileNode.functionCallMissedPerLine) && Objects.equals(this.mutations, fileNode.mutations) && Objects.equals(this.modifiedLines, fileNode.modifiedLines) && Objects.equals(this.indirectCoverageChanges, fileNode.indirectCoverageChanges) && Objects.equals(this.coverageDelta, fileNode.coverageDelta) && Objects.equals(this.relativePath, fileNode.relativePath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.coveredPerLine, this.missedPerLine, this.mutations, this.modifiedLines, this.mcdcPairCoveredPerLine, this.mcdcPairMissedPerLine, this.functionCallCoveredPerLine, this.functionCallMissedPerLine, this.indirectCoverageChanges, this.coverageDelta, this.relativePath);
    }

    @Override
    public boolean isAggregation() {
        return false;
    }
}

