/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

class CoverageMetricsValues {
    private int covered;
    private int missed;
    private int total;

    CoverageMetricsValues(int covered, int missed) {
        this.covered = covered;
        this.missed = missed;
        this.total = covered + missed;
    }

    public int getTotal() {
        return this.total;
    }

    public int getCovered() {
        return this.covered;
    }

    public int getMissed() {
        return this.missed;
    }

    public void clearMissed() {
        this.missed = 0;
    }

    public void setCoveredFromMax(CoverageMetricsValues other) {
        this.covered = Math.max(this.total, other.getTotal());
    }

    public void setTotalFromCovered() {
        this.total = this.covered;
    }

    public boolean hasAnyInfo() {
        return this.total > 1;
    }

    public boolean totalsNotEqual(CoverageMetricsValues other) {
        return this.total != other.total;
    }

    public boolean noMissing() {
        return this.total == this.covered;
    }

    public int getMaxCovered(CoverageMetricsValues other) {
        return Math.max(this.covered, other.getCovered());
    }

    public int getMinMissed(CoverageMetricsValues other) {
        return Math.min(this.missed, other.getMissed());
    }
}

