/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.echarts.line.LinesChartModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Job;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.coverage.metrics.steps.TrendChartFactory;
import io.jenkins.plugins.echarts.ActionSelector;
import io.jenkins.plugins.echarts.TrendChartJobAction;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class CoverageJobAction
extends TrendChartJobAction<CoverageBuildAction> {
    private static final LinesChartModel EMPTY_CHART = new LinesChartModel();
    private final String id;
    private final String name;
    private final String icon;

    CoverageJobAction(Job<?, ?> owner, String id, String name, String icon) {
        super(owner, CoverageBuildAction.class);
        this.id = id;
        this.name = name;
        this.icon = icon;
    }

    public String getIconFileName() {
        return this.icon;
    }

    public String getDisplayName() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.name, (CharSequence)Messages.Coverage_Link_Name());
    }

    public String getTrendName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            return Messages.Coverage_Trend_Default_Name();
        }
        return Messages.Coverage_Trend_Name(this.name);
    }

    @NonNull
    public String getUrlName() {
        return this.id;
    }

    public Job<?, ?> getProject() {
        return this.getOwner();
    }

    public String getSearchUrl() {
        return this.getUrlName();
    }

    public List<Metric> getTrendMetrics() {
        Optional<CoverageBuildAction> latestAction = this.getLatestAction();
        return latestAction.stream().map(a -> a.getAllValues(Baseline.PROJECT)).flatMap(Collection::stream).map(Value::getMetric).filter(m -> !TrendChartFactory.IGNORED_TREND_METRICS.contains(m)).filter(m -> m.isCoverage() || latestAction.map(a -> !a.hasCoverage()).orElse(true) != false).toList();
    }

    protected LinesChartModel createChartModel(String configuration) {
        Optional<CoverageBuildAction> latestAction = this.getLatestAction();
        return latestAction.map(a -> new TrendChartFactory().createChartModel(configuration, (CoverageBuildAction)((Object)a))).orElse(EMPTY_CHART);
    }

    public Optional<CoverageBuildAction> getLatestAction() {
        return new ActionSelector(CoverageBuildAction.class, action -> this.getUrlName().equals(action.getUrlName())).findFirst(this.getOwner().getLastBuild());
    }
}

