/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import hudson.model.ModelObject;
import hudson.model.Run;
import io.jenkins.plugins.coverage.metrics.source.Messages;
import io.jenkins.plugins.coverage.metrics.source.SourceCodeFacade;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SourceViewModel
implements ModelObject {
    private static final SourceCodeFacade SOURCE_CODE_FACADE = new SourceCodeFacade();
    private final Run<?, ?> owner;
    private final String id;
    private final FileNode fileNode;

    public SourceViewModel(Run<?, ?> owner, String id, FileNode fileNode) {
        this.owner = owner;
        this.id = id;
        this.fileNode = fileNode;
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    public FileNode getNode() {
        return this.fileNode;
    }

    public String getSourceFileContent() {
        try {
            return SOURCE_CODE_FACADE.read(this.getOwner().getRootDir(), this.id, this.getNode().getRelativePath());
        }
        catch (IOException | InterruptedException exception) {
            return ExceptionUtils.getStackTrace((Throwable)exception);
        }
    }

    public boolean isSourceFileAvailable() {
        return SOURCE_CODE_FACADE.canRead(this.getOwner().getRootDir(), this.id, this.fileNode.getRelativePath());
    }

    public String getDisplayName() {
        return Messages.Coverage_Title(this.getNode().getName());
    }
}

