/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.source;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Mutation;
import io.jenkins.plugins.coverage.metrics.source.CoverageSourcePrinter;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.UnescapedText;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

final class MutationSourcePrinter
extends CoverageSourcePrinter {
    private static final long serialVersionUID = -2215657894423024907L;
    private final int[] survivedPerLine = new int[this.size()];
    private final int[] killedPerLine = new int[this.size()];
    private final String[] tooltipPerLine = new String[this.size()];

    MutationSourcePrinter(FileNode file) {
        super(file);
        Arrays.fill(this.tooltipPerLine, "");
        this.extractMutationDetails(file.getMutationsPerLine());
        for (Mutation mutation : file.getMutations()) {
            if (mutation.hasSurvived()) {
                int n = this.findIndexOfLine(mutation.getLine());
                this.survivedPerLine[n] = this.survivedPerLine[n] + 1;
                continue;
            }
            if (!mutation.isKilled()) continue;
            int n = this.findIndexOfLine(mutation.getLine());
            this.killedPerLine[n] = this.killedPerLine[n] + 1;
        }
    }

    private void extractMutationDetails(NavigableMap<Integer, List<Mutation>> mutationsPerLine) {
        for (Map.Entry entry : mutationsPerLine.entrySet()) {
            int indexOfLine = this.findIndexOfLine((Integer)entry.getKey());
            this.tooltipPerLine[indexOfLine] = this.createInfo((List)entry.getValue());
        }
    }

    private String createInfo(List<Mutation> allMutations) {
        ContainerTag killedContainer = this.listMutations(allMutations, Mutation::isKilled, "Killed Mutations:");
        ContainerTag survivedContainer = this.listMutations(allMutations, Mutation::hasSurvived, "Survived Mutations:");
        if (killedContainer.getNumChildren() == 0 && survivedContainer.getNumChildren() == 0) {
            return "Not covered";
        }
        return TagCreator.div().with(new DomContent[]{killedContainer, survivedContainer}).render();
    }

    private ContainerTag listMutations(List<Mutation> allMutations, Predicate<Mutation> predicate, String title) {
        ContainerTag filtered = TagCreator.div();
        List<ContainerTag> killed = this.asBulletPoints(allMutations, predicate);
        if (!killed.isEmpty()) {
            filtered.with((DomContent)TagCreator.div().with(new DomContent[]{new UnescapedText(title), TagCreator.ul().with(killed)}));
        }
        return filtered;
    }

    private List<ContainerTag> asBulletPoints(List<Mutation> mutations, Predicate<Mutation> predicate) {
        return mutations.stream().filter(predicate).map(mutation -> TagCreator.li().withText("%s (%s)".formatted(mutation.getDescription(), mutation.getMutator()))).collect(Collectors.toList());
    }

    public int getSurvived(int line) {
        return this.getCounter(line, this.survivedPerLine);
    }

    public int getKilled(int line) {
        return this.getCounter(line, this.killedPerLine);
    }

    @Override
    public String getColorClass(int line) {
        if (this.getCovered(line) == 0) {
            return "coverNone";
        }
        if (this.getKilled(line) == 0) {
            return "coverNone";
        }
        if (this.getSurvived(line) == 0) {
            return "coverFull";
        }
        return "coverPart";
    }

    @Override
    public String getTooltip(int line) {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.tooltipPerLine[this.findIndexOfLine(line)], (CharSequence)super.getTooltip(line));
    }

    @Override
    public String getSummaryColumn(int line) {
        int killed = this.getKilled(line);
        int survived = this.getSurvived(line);
        if (survived + killed > 0) {
            return "%d/%d".formatted(killed, survived + killed);
        }
        return String.valueOf(killed);
    }
}

