/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.model;

import edu.hm.hafner.coverage.Coverage;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Percentage;
import edu.hm.hafner.coverage.Value;
import hudson.Functions;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;
import io.jenkins.plugins.coverage.metrics.color.ColorProviderFactory;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.Messages;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class ElementFormatter {
    private static final Pattern PERCENTAGE = Pattern.compile("\\d+(\\.\\d+)?%");

    public String getTooltip(Value value) {
        return value.getDetails(this.getLocale());
    }

    public String format(Value value) {
        return this.format(value, this.getLocale());
    }

    private Locale getLocale() {
        return Functions.getCurrentLocale();
    }

    public String format(Value value, Locale locale) {
        return value.asText(locale);
    }

    public String formatDetails(Value value) {
        return this.formatDetails(value, this.getLocale());
    }

    private String formatDetails(Value value, Locale locale) {
        return value.asInformativeText(locale);
    }

    public String formatAdditionalInformation(Value value) {
        Coverage coverage;
        if (value instanceof Coverage && (coverage = (Coverage)value).isSet()) {
            return this.formatAdditionalCoverageInformation(coverage);
        }
        return "";
    }

    private String formatAdditionalCoverageInformation(Coverage coverage) {
        if (coverage.getMetric() == Metric.MUTATION || coverage.getMetric() == Metric.TEST_STRENGTH) {
            return ElementFormatter.formatCoverage(coverage, Messages.Metric_MUTATION_Killed(), Messages.Metric_MUTATION_Survived());
        }
        return ElementFormatter.formatCoverage(coverage, Messages.Metric_Coverage_Covered(), Messages.Metric_Coverage_Missed());
    }

    private static String formatCoverage(Coverage coverage, String coveredText, String missedText) {
        return "%s: %d - %s: %d".formatted(coveredText, coverage.getCovered(), missedText, coverage.getMissed());
    }

    public boolean showColors(Value value) {
        return value instanceof Coverage;
    }

    public ColorProvider.DisplayColors getDisplayColors(Baseline baseline, Value value) {
        ColorProvider defaultColorProvider = ColorProviderFactory.createDefaultColorProvider();
        if (value instanceof Coverage) {
            Coverage coverage = (Coverage)value;
            return baseline.getDisplayColors(coverage.getCoveredPercentage().toDouble(), defaultColorProvider);
        }
        return baseline.getDisplayColors(value.asDouble(), defaultColorProvider);
    }

    public String formatValue(Value value) {
        return this.formatDetails(value, this.getLocale());
    }

    public String formatValueWithMetric(Value value) {
        return value.getSummary(this.getLocale());
    }

    public String formatDetailedValueWithMetric(Value value) {
        return value.getDetails(this.getLocale());
    }

    public String getBackgroundColorFillPercentage(String percentage) {
        String formattedPercentage = percentage.replace(",", ".");
        if (PERCENTAGE.matcher(formattedPercentage).matches()) {
            return formattedPercentage;
        }
        return "100%";
    }

    public String getBackgroundColorFillPercentage(Value value) {
        if (value instanceof Coverage) {
            return this.format(value, Locale.ENGLISH);
        }
        return "100%";
    }

    public String formatPercentage(Coverage coverage, Locale locale) {
        return coverage.asText(locale);
    }

    private String formatPercentage(Percentage fraction, Locale locale) {
        return String.format(locale, "%.2f%%", fraction.toDouble());
    }

    public String formatPercentage(int covered, int total, Locale locale) {
        return this.formatPercentage(Percentage.valueOf((int)covered, (int)total), locale);
    }

    public String formatDelta(Metric metric, Value value, Locale locale) {
        return this.formatDelta(value, locale);
    }

    public String formatDelta(Value value, Locale locale) {
        return value.asText(locale);
    }

    public String getDisplayName(Metric metric) {
        return metric.getDisplayName();
    }

    public List<String> getSortedCoverageDisplayNames() {
        return Metric.getCoverageMetrics().stream().map(this::getDisplayName).collect(Collectors.toList());
    }

    public List<String> getFormattedValues(Stream<? extends Value> values, Locale locale) {
        return values.map(value -> this.formatDetails((Value)value, locale)).collect(Collectors.toList());
    }

    public String getLabel(Metric metric) {
        return metric.getLabel();
    }

    public String getDisplayName(Baseline baseline) {
        return switch (baseline) {
            default -> throw new IncompatibleClassChangeError();
            case Baseline.PROJECT -> Messages.Baseline_PROJECT();
            case Baseline.MODIFIED_LINES -> Messages.Baseline_MODIFIED_LINES();
            case Baseline.MODIFIED_FILES -> Messages.Baseline_MODIFIED_FILES();
            case Baseline.PROJECT_DELTA -> Messages.Baseline_PROJECT_DELTA();
            case Baseline.MODIFIED_LINES_DELTA -> Messages.Baseline_MODIFIED_LINES_DELTA();
            case Baseline.MODIFIED_FILES_DELTA -> Messages.Baseline_MODIFIED_FILES_DELTA();
            case Baseline.INDIRECT -> Messages.Baseline_INDIRECT();
        };
    }

    public ListBoxModel getMetricItems() {
        ListBoxModel options = new ListBoxModel();
        Arrays.stream(Metric.values()).filter(m -> m != Metric.CONTAINER).forEach(m -> options.add(m.getDisplayName(), m.name()));
        return options;
    }

    public ListBoxModel getBaselineItems() {
        ListBoxModel options = new ListBoxModel();
        this.add(options, Baseline.PROJECT);
        this.add(options, Baseline.MODIFIED_LINES);
        this.add(options, Baseline.MODIFIED_FILES);
        this.add(options, Baseline.PROJECT_DELTA);
        this.add(options, Baseline.MODIFIED_LINES_DELTA);
        this.add(options, Baseline.MODIFIED_FILES_DELTA);
        return options;
    }

    private void add(ListBoxModel options, Baseline baseline) {
        options.add(this.getDisplayName(baseline), baseline.name());
    }
}

