/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.model;

import edu.hm.hafner.coverage.Difference;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public class CoverageStatistics {
    private final List<Value> projectValueMapping;
    private final List<Difference> projectDelta;
    private final List<Value> changeValueMapping;
    private final List<Difference> changeDelta;
    private final List<Value> fileValueMapping;
    private final List<Difference> fileDelta;

    public CoverageStatistics(List<? extends Value> projectValueMapping, List<? extends Difference> projectDeltaMapping, List<? extends Value> modifiedLinesValueMapping, List<? extends Difference> modifiedLinesDeltaMapping, List<? extends Value> modifiedFilesValueMapping, List<? extends Difference> modifiedFilesDeltaMapping) {
        this.projectValueMapping = List.copyOf(projectValueMapping);
        this.changeValueMapping = List.copyOf(modifiedLinesValueMapping);
        this.fileValueMapping = List.copyOf(modifiedFilesValueMapping);
        this.projectDelta = List.copyOf(projectDeltaMapping);
        this.changeDelta = List.copyOf(modifiedLinesDeltaMapping);
        this.fileDelta = List.copyOf(modifiedFilesDeltaMapping);
    }

    public Optional<Value> getValue(Baseline baseline, Metric metric) {
        if (baseline == Baseline.PROJECT) {
            return Value.findValue((Metric)metric, this.projectValueMapping);
        }
        if (baseline == Baseline.MODIFIED_FILES) {
            return Value.findValue((Metric)metric, this.fileValueMapping);
        }
        if (baseline == Baseline.MODIFIED_LINES) {
            return Value.findValue((Metric)metric, this.changeValueMapping);
        }
        if (baseline == Baseline.PROJECT_DELTA) {
            return Value.findValue((Metric)metric, this.projectDelta);
        }
        if (baseline == Baseline.MODIFIED_LINES_DELTA) {
            return Value.findValue((Metric)metric, this.changeDelta);
        }
        if (baseline == Baseline.MODIFIED_FILES_DELTA) {
            return Value.findValue((Metric)metric, this.fileDelta);
        }
        throw new NoSuchElementException("No such baseline: " + String.valueOf((Object)baseline));
    }

    public double roundValue(Baseline baseline, Metric metric) {
        return this.getValue(baseline, metric).map(Value::asRounded).orElse(0.0);
    }

    public double roundValue(Metric metric) {
        return this.roundValue(Baseline.PROJECT, metric);
    }

    public boolean containsValue(Metric metric, Baseline baseline) {
        return this.getValue(baseline, metric).isPresent();
    }

    public boolean containsValue(Metric metric) {
        return this.containsValue(metric, Baseline.PROJECT);
    }
}

