/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.coverage.metrics.color.ColorId;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;

public enum CoverageLevel {
    LVL_95(95.0, ColorId.EXCELLENT),
    LVL_90(90.0, ColorId.VERY_GOOD),
    LVL_80(85.0, ColorId.GOOD),
    LVL_75(80.0, ColorId.AVERAGE),
    LVL_70(70.0, ColorId.INADEQUATE),
    LVL_60(60.0, ColorId.BAD),
    LVL_50(50.0, ColorId.VERY_BAD),
    LVL_0(0.0, ColorId.INSUFFICIENT),
    NA(-1.0, ColorId.WHITE);

    private final double level;
    private final ColorId colorizationId;

    private CoverageLevel(double level, ColorId colorizationId) {
        this.level = level;
        this.colorizationId = colorizationId;
    }

    public static ColorProvider.DisplayColors getDisplayColorsOfCoverageLevel(double coveragePercentage, @NonNull ColorProvider colorProvider) {
        if (coveragePercentage >= 0.0) {
            return CoverageLevel.getBlendedColors(coveragePercentage, colorProvider);
        }
        return colorProvider.getDisplayColorsOf(CoverageLevel.NA.colorizationId);
    }

    private static ColorProvider.DisplayColors getBlendedColors(double coveragePercentage, @NonNull ColorProvider colorProvider) {
        for (int i = 0; i < CoverageLevel.values().length - 1; ++i) {
            CoverageLevel level = CoverageLevel.values()[i];
            if (!(coveragePercentage >= level.level)) continue;
            if (i == 0) {
                return colorProvider.getDisplayColorsOf(level.colorizationId);
            }
            double distanceLevel = coveragePercentage - level.level;
            if (distanceLevel == 0.0) {
                return colorProvider.getDisplayColorsOf(level.colorizationId);
            }
            CoverageLevel upperLevel = CoverageLevel.values()[i - 1];
            double distanceUpper = upperLevel.level - coveragePercentage;
            return colorProvider.getBlendedDisplayColors(distanceLevel, distanceUpper, upperLevel.colorizationId, level.colorizationId);
        }
        return colorProvider.getDisplayColorsOf(CoverageLevel.NA.colorizationId);
    }

    public double getLevel() {
        return this.level;
    }

    public ColorId getColorizationId() {
        return this.colorizationId;
    }
}

