/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import java.util.Locale;
import org.apache.commons.lang3.math.Fraction;

public class Difference
extends Value {
    private static final long serialVersionUID = -1115727256219835389L;
    public static final String DELTA = "\u0394";

    public static Difference nullObject(Metric metric) {
        return new Difference(metric, 0);
    }

    public static Difference valueOf(String stringRepresentation) {
        Value value = Value.valueOf(stringRepresentation);
        if (value instanceof Difference) {
            Difference delta = (Difference)value;
            return delta;
        }
        throw new IllegalArgumentException("Cannot convert '%s' to a valid Difference instance.".formatted(stringRepresentation));
    }

    public Difference(Metric metric, Fraction value) {
        super(metric, value);
    }

    public Difference(Metric metric, double value) {
        super(metric, value);
    }

    public Difference(Metric metric, int numerator, int denominator) {
        super(metric, numerator, denominator);
    }

    public Difference(Metric metric, int value) {
        super(metric, value);
    }

    @Override
    public String asText(Locale locale) {
        return this.getMetric().formatDelta(locale, this.asDouble());
    }

    @Override
    public String asInformativeText(Locale locale) {
        return this.getMetric().formatDelta(locale, this.asDouble());
    }

    @Override
    protected String serializeValue() {
        return DELTA + super.serializeValue();
    }
}

