/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Value;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.line.LinesChartModel;
import io.jenkins.plugins.coverage.metrics.charts.CoverageTrendChart;
import io.jenkins.plugins.coverage.metrics.charts.MetricsTrendChart;
import io.jenkins.plugins.coverage.metrics.charts.TrendChart;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.coverage.metrics.steps.CoverageBuildAction;
import io.jenkins.plugins.echarts.GenericBuildActionIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class TrendChartFactory {
    private static final JacksonFacade JACKSON = new JacksonFacade();
    static final Set<Metric> DEFAULT_TREND_METRICS = Set.of(Metric.LINE, Metric.BRANCH, Metric.MUTATION, Metric.TEST_STRENGTH, Metric.NCSS, Metric.LOC, Metric.CYCLOMATIC_COMPLEXITY, Metric.COGNITIVE_COMPLEXITY);
    static final Set<Metric> IGNORED_TREND_METRICS = Set.of(Metric.ACCESS_TO_FOREIGN_DATA, Metric.WEIGHED_METHOD_COUNT, Metric.NUMBER_OF_ACCESSORS, Metric.WEIGHT_OF_CLASS, Metric.COHESION, Metric.CONTAINER, Metric.FAN_OUT, Metric.MODULE);

    TrendChartFactory() {
    }

    LinesChartModel createMetricsModel(String configuration, CoverageBuildAction latestAction) {
        return this.getLinesChartModel(configuration, latestAction, true);
    }

    LinesChartModel createChartModel(String configuration, CoverageBuildAction latestAction) {
        return this.getLinesChartModel(configuration, latestAction, false);
    }

    private LinesChartModel getLinesChartModel(String configuration, CoverageBuildAction latestAction, boolean isMetric) {
        GenericBuildActionIterator.BuildActionIterable buildActions = new GenericBuildActionIterator.BuildActionIterable(CoverageBuildAction.class, Optional.of(latestAction), action -> latestAction.getUrlName().equals(action.getUrlName()), CoverageBuildAction::getStatistics);
        Set<Metric> actualValues = latestAction.getAllValues(Baseline.PROJECT).stream().map(Value::getMetric).collect(Collectors.toSet());
        actualValues.retainAll(this.getVisibleMetrics(configuration));
        return this.getTrendChartType(latestAction, actualValues, this.useLines(configuration), isMetric).create((Iterable<BuildResult<CoverageStatistics>>)buildActions, ChartModelConfiguration.fromJson((String)configuration));
    }

    private boolean useLines(String configuration) {
        return JACKSON.getBoolean(configuration, "useLines", false);
    }

    Set<Metric> getVisibleMetrics(String configuration) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode jsonNodes = (ObjectNode)objectMapper.readValue(configuration, ObjectNode.class);
            JsonNode metrics = jsonNodes.get("metrics");
            Map metricMapping = (Map)objectMapper.convertValue((Object)metrics, Map.class);
            if (metricMapping != null && !metricMapping.isEmpty()) {
                return metricMapping.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).map(Metric::valueOf).collect(Collectors.toSet());
            }
        }
        catch (JsonProcessingException | ClassCastException | IllegalArgumentException throwable) {
            // empty catch block
        }
        return DEFAULT_TREND_METRICS;
    }

    private TrendChart getTrendChartType(CoverageBuildAction latestAction, Set<Metric> visibleMetrics, boolean useLines, boolean isMetric) {
        boolean hasCoverage = latestAction.getAllValues(Baseline.PROJECT).stream().map(Value::getMetric).anyMatch(Metric::isCoverage);
        if (isMetric || !hasCoverage) {
            return new MetricsTrendChart(visibleMetrics, useLines);
        }
        return new CoverageTrendChart(visibleMetrics, useLines);
    }
}

