/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Objects;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"coverage"})
public class CoverageAppearanceConfiguration
extends GlobalConfigurationItem {
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private boolean enableColumnByDefault = true;
    private Metric defaultMetric = Metric.LINE;
    private String defaultName = Messages.Coverage_Column();
    private final JenkinsFacade jenkins;

    public static CoverageAppearanceConfiguration getInstance() {
        return Objects.requireNonNull((CoverageAppearanceConfiguration)((Object)CoverageAppearanceConfiguration.all().get(CoverageAppearanceConfiguration.class)));
    }

    @DataBoundConstructor
    public CoverageAppearanceConfiguration() {
        this.jenkins = new JenkinsFacade();
        this.load();
    }

    @VisibleForTesting
    CoverageAppearanceConfiguration(GlobalConfigurationFacade facade, JenkinsFacade jenkins) {
        super(facade);
        this.jenkins = jenkins;
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    public boolean isEnableColumnByDefault() {
        return this.enableColumnByDefault;
    }

    @DataBoundSetter
    public void setEnableColumnByDefault(boolean enableColumnByDefault) {
        this.enableColumnByDefault = enableColumnByDefault;
        this.save();
    }

    public Metric getDefaultMetric() {
        return this.defaultMetric;
    }

    @DataBoundSetter
    public void setDefaultMetric(Metric defaultMetric) {
        this.defaultMetric = defaultMetric;
        this.save();
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    @DataBoundSetter
    public void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
        this.save();
    }

    @POST
    public ListBoxModel doFillDefaultMetricItems() {
        if (this.jenkins.hasPermission(Jenkins.READ)) {
            return FORMATTER.getMetricItems();
        }
        return new ListBoxModel();
    }
}

