/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.charts;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.line.LinesChartModel;
import edu.hm.hafner.echarts.line.LinesDataSet;
import edu.hm.hafner.util.VisibleForTesting;
import io.jenkins.plugins.coverage.metrics.charts.CoverageSeriesBuilder;
import io.jenkins.plugins.coverage.metrics.charts.TrendChart;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import io.jenkins.plugins.echarts.JenkinsPalette;
import java.util.List;
import java.util.Set;

public class CoverageTrendChart
extends TrendChart {
    @VisibleForTesting
    CoverageTrendChart() {
        super(Set.of(), false);
    }

    public CoverageTrendChart(Set<Metric> visibleMetrics, boolean useLines) {
        super(visibleMetrics, useLines);
    }

    @Override
    public LinesChartModel create(Iterable<BuildResult<CoverageStatistics>> results, ChartModelConfiguration configuration) {
        LinesDataSet dataSet = new CoverageSeriesBuilder().createDataSet(configuration, results);
        LinesChartModel model = new LinesChartModel(dataSet);
        if (dataSet.isNotEmpty()) {
            int colorIndex = 0;
            for (Metric metric : List.of(Metric.MODULE, Metric.PACKAGE, Metric.FILE, Metric.CLASS, Metric.METHOD)) {
                this.addSeriesIfAvailable(dataSet, model, metric, JenkinsPalette.chartColor((int)colorIndex).normal());
                ++colorIndex;
            }
            this.addSeriesIfAvailable(dataSet, model, Metric.LINE, JenkinsPalette.GREEN.normal());
            this.addSeriesIfAvailable(dataSet, model, Metric.BRANCH, JenkinsPalette.GREEN.dark());
            this.addSeriesIfAvailable(dataSet, model, Metric.INSTRUCTION, JenkinsPalette.GREEN.light());
            this.addSeriesIfAvailable(dataSet, model, Metric.MUTATION, JenkinsPalette.GREEN.dark());
            this.addSeriesIfAvailable(dataSet, model, Metric.TEST_STRENGTH, JenkinsPalette.GREEN.light());
            this.addSeriesIfAvailable(dataSet, model, Metric.MCDC_PAIR, JenkinsPalette.RED.light());
            this.addSeriesIfAvailable(dataSet, model, Metric.FUNCTION_CALL, JenkinsPalette.RED.dark());
            model.useContinuousRangeAxis();
            model.computeVisibleRange();
            model.setRangeMax(100.0);
        }
        return model;
    }
}

