/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.FileNode;
import edu.hm.hafner.coverage.Node;
import io.jenkins.plugins.forensics.delta.Change;
import io.jenkins.plugins.forensics.delta.ChangeEditType;
import io.jenkins.plugins.forensics.delta.FileChanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FileChangesProcessor {
    public void attachChangedCodeLines(Node coverageNode, Map<String, FileChanges> codeChanges) {
        Map nodePathMapping = coverageNode.getAllFileNodes().stream().collect(Collectors.toMap(FileNode::getRelativePath, Function.identity()));
        codeChanges.forEach((path, fileChange) -> {
            if (nodePathMapping.containsKey(path)) {
                FileNode changedNode = (FileNode)nodePathMapping.get(path);
                this.attachChanges(changedNode, fileChange.getChangesByType(ChangeEditType.INSERT));
                this.attachChanges(changedNode, fileChange.getChangesByType(ChangeEditType.REPLACE));
            }
        });
    }

    private void attachChanges(FileNode changedNode, Set<Change> relevantChanges) {
        for (Change change : relevantChanges) {
            int i = change.getFromLine();
            while (i <= change.getToLine()) {
                changedNode.addModifiedLines(new int[]{i++});
            }
        }
    }

    public void attachFileCoverageDeltas(Node root, Node referenceNode, Map<String, String> oldPathMapping) {
        Map<String, FileNode> fileNodes = this.getFileNodeMappingWithReferencePaths(root, oldPathMapping);
        Map<String, FileNode> referenceFileNodes = this.getReferenceFileNodeMapping(fileNodes, referenceNode);
        fileNodes.entrySet().stream().filter(entry -> referenceFileNodes.containsKey(entry.getKey())).forEach(entry -> this.attachFileCoverageDelta((FileNode)entry.getValue(), (FileNode)referenceFileNodes.get(entry.getKey())));
    }

    private void attachFileCoverageDelta(FileNode fileNode, FileNode referenceNode) {
        fileNode.computeDelta(referenceNode);
    }

    public void attachIndirectCoveragesChanges(Node root, Node referenceNode, Map<String, FileChanges> codeChanges, Map<String, String> oldPathMapping) {
        Map<String, FileNode> fileNodes = this.getFileNodeMappingWithReferencePaths(root, oldPathMapping);
        Map<String, FileNode> referenceFileNodes = this.getReferenceFileNodeMapping(fileNodes, referenceNode);
        for (Map.Entry<String, FileNode> entry : fileNodes.entrySet()) {
            String referencePath = entry.getKey();
            FileNode fileNode = entry.getValue();
            Optional<SortedMap<Integer, Integer>> referenceCoveragePerLine = this.getReferenceCoveragePerLine(referenceFileNodes, referencePath);
            if (!referenceCoveragePerLine.isPresent()) continue;
            TreeMap<Integer, Integer> referenceCoverageMapping = new TreeMap<Integer, Integer>(referenceCoveragePerLine.get());
            String currentPath = fileNode.getRelativePath();
            if (codeChanges.containsKey(currentPath)) {
                this.adjustedCoveragePerLine(referenceCoverageMapping, codeChanges.get(currentPath));
            }
            this.attachIndirectCoverageChangeForFile(fileNode, referenceCoverageMapping);
        }
    }

    private void attachIndirectCoverageChangeForFile(FileNode fileNode, SortedMap<Integer, Integer> referenceCoverageMapping) {
        fileNode.getLinesWithCoverage().forEach(line -> {
            if (!fileNode.hasModifiedLine(line.intValue()) && referenceCoverageMapping.containsKey(line)) {
                int referenceCovered = (Integer)referenceCoverageMapping.get(line);
                int covered = fileNode.getCoveredOfLine(line.intValue());
                if (covered != referenceCovered) {
                    fileNode.addIndirectCoverageChange(line.intValue(), covered - referenceCovered);
                }
            }
        });
    }

    private Optional<SortedMap<Integer, Integer>> getReferenceCoveragePerLine(Map<String, FileNode> references, String fullyQualifiedName) {
        NavigableMap coveragePerLine;
        if (references.containsKey(fullyQualifiedName) && !(coveragePerLine = references.get(fullyQualifiedName).getCounters()).isEmpty()) {
            return Optional.of(coveragePerLine);
        }
        return Optional.empty();
    }

    private void adjustedCoveragePerLine(SortedMap<Integer, Integer> coveragePerLine, FileChanges fileChanges) {
        List<List<Integer>> coverages = this.transformCoveragePerLine(coveragePerLine, fileChanges);
        fileChanges.getChangesByType(ChangeEditType.DELETE).forEach(change -> {
            for (int i = change.getChangedFromLine(); i <= change.getChangedToLine(); ++i) {
                ((List)coverages.get(i)).clear();
            }
        });
        fileChanges.getChangesByType(ChangeEditType.INSERT).forEach(change -> {
            List inserted = (List)coverages.get(change.getChangedFromLine());
            int changedLinesNumber = change.getToLine() - change.getFromLine() + 1;
            this.fillCoverageListWithNull(inserted, changedLinesNumber);
        });
        fileChanges.getChangesByType(ChangeEditType.REPLACE).forEach(change -> {
            List replaced = (List)coverages.get(change.getChangedFromLine());
            replaced.clear();
            int changedLinesNumber = change.getToLine() - change.getFromLine() + 1;
            this.fillCoverageListWithNull(replaced, changedLinesNumber);
            for (int i = change.getChangedFromLine() + 1; i <= change.getChangedToLine(); ++i) {
                ((List)coverages.get(i)).clear();
            }
        });
        List adjustedCoveragesList = coverages.stream().flatMap(Collection::stream).collect(Collectors.toList());
        coveragePerLine.clear();
        for (int line = 1; line < adjustedCoveragesList.size(); ++line) {
            Integer coverage = (Integer)adjustedCoveragesList.get(line);
            if (coverage == null) continue;
            coveragePerLine.put(line, coverage);
        }
    }

    private List<List<Integer>> transformCoveragePerLine(SortedMap<Integer, Integer> coveragePerLine, FileChanges fileChanges) {
        List<List<Integer>> coverages = coveragePerLine.values().stream().map(coverage -> new ArrayList<Integer>(Collections.singletonList(coverage))).collect(Collectors.toList());
        int maxLineNumber = coveragePerLine.lastKey();
        Optional<Integer> highestLineNumber = fileChanges.getChanges().values().stream().flatMap(Collection::stream).map(Change::getChangedToLine).max(Comparator.naturalOrder());
        if (highestLineNumber.isPresent() && highestLineNumber.get() > maxLineNumber) {
            maxLineNumber = highestLineNumber.get();
        }
        IntStream.range(0, maxLineNumber + 1).filter(line -> !coveragePerLine.containsKey(line)).forEach(line -> {
            if (line < coverages.size()) {
                coverages.add(line, new ArrayList<Object>(Collections.singletonList(null)));
            } else {
                coverages.add(new ArrayList<Object>(Collections.singletonList(null)));
            }
        });
        return coverages;
    }

    private Map<String, FileNode> getFileNodeMappingWithReferencePaths(Node root, Map<String, String> oldPathMapping) {
        return root.getAllFileNodes().stream().filter(node -> oldPathMapping.containsKey(node.getRelativePath())).collect(Collectors.toMap(node -> (String)oldPathMapping.get(node.getRelativePath()), Function.identity()));
    }

    private Map<String, FileNode> getReferenceFileNodeMapping(Map<String, FileNode> nodeMapping, Node referenceNode) {
        return referenceNode.getAllFileNodes().stream().filter(reference -> nodeMapping.containsKey(reference.getRelativePath())).collect(Collectors.toMap(FileNode::getRelativePath, Function.identity()));
    }

    private void fillCoverageListWithNull(List<Integer> coverageList, int number) {
        for (int i = 0; i < number; ++i) {
            coverageList.add(null);
        }
    }
}

