/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.CoverageParser;
import edu.hm.hafner.coverage.ModuleNode;
import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.SecureXmlParserFactory;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTool;
import io.jenkins.plugins.util.AgentFileVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.io.input.BOMInputStream;

public class CoverageReportScanner
extends AgentFileVisitor<ModuleNode> {
    private static final long serialVersionUID = 6940864958150044554L;
    private static final PathUtil PATH_UTIL = new PathUtil();
    private final CoverageTool.Parser parser;
    private final CoverageParser.ProcessingMode processingMode;

    public CoverageReportScanner(CoverageTool.Parser parser, String filePattern, String encoding, boolean followSymbolicLinks, CoverageParser.ProcessingMode processingMode) {
        super(filePattern, encoding, followSymbolicLinks, true);
        this.parser = parser;
        this.processingMode = processingMode;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Optional<ModuleNode> processFile(Path file, Charset charset, FilteredLog log) {
        CoverageParser coverageParser = this.parser.createParser(this.processingMode);
        try (BOMInputStream inputStream = ((BOMInputStream.Builder)((BOMInputStream.Builder)BOMInputStream.builder().setFile(file.toFile())).setCharset(charset)).get();){
            Optional<ModuleNode> optional;
            try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);){
                ModuleNode node = coverageParser.parse((Reader)reader, file.toString(), log);
                log.logInfo("Successfully parsed file '%s'", new Object[]{PATH_UTIL.getAbsolutePath(file)});
                node.aggregateValues().forEach(v -> log.logInfo("%s", new Object[]{v}));
                optional = Optional.of(node);
            }
            return optional;
        }
        catch (SecureXmlParserFactory.ParsingException | IOException exception) {
            log.logException((Exception)exception, "Parsing of file '%s' failed due to an exception:", new Object[]{file});
            return Optional.empty();
        }
    }
}

