/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.color;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jenkins.plugins.coverage.metrics.color.ColorId;
import io.jenkins.plugins.coverage.metrics.color.ColorProvider;

public enum CoverageChangeTendency {
    INCREASED(ColorId.EXCELLENT),
    EQUALS(ColorId.AVERAGE),
    DECREASED(ColorId.INSUFFICIENT),
    NA(ColorId.WHITE);

    private final ColorId colorizationId;

    private CoverageChangeTendency(ColorId colorizationId) {
        this.colorizationId = colorizationId;
    }

    public static ColorProvider.DisplayColors getDisplayColorsForTendency(Double change, @NonNull ColorProvider colorProvider) {
        ColorId colorId = change == null || change.isNaN() ? CoverageChangeTendency.NA.colorizationId : (change > 0.0 ? CoverageChangeTendency.INCREASED.colorizationId : (change < 0.0 ? CoverageChangeTendency.DECREASED.colorizationId : CoverageChangeTendency.EQUALS.colorizationId));
        return colorProvider.getDisplayColorsOf(colorId);
    }

    public ColorId getColorizationId() {
        return this.colorizationId;
    }
}

