/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.charts;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.line.LineSeries;
import edu.hm.hafner.echarts.line.LinesChartModel;
import edu.hm.hafner.echarts.line.LinesDataSet;
import io.jenkins.plugins.coverage.metrics.charts.CoverageTrendChart;
import io.jenkins.plugins.coverage.metrics.charts.MetricsTrendChart;
import io.jenkins.plugins.coverage.metrics.model.CoverageStatistics;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class TrendChart {
    private static final Set<Metric> ALL_METRICS = Arrays.stream(Metric.values()).collect(Collectors.toSet());
    private final Set<Metric> visibleMetrics;
    private final LineSeries.FilledMode filledMode;

    public static TrendChart createTrendChart(boolean metrics) {
        return metrics ? new MetricsTrendChart(ALL_METRICS, true) : new CoverageTrendChart(ALL_METRICS, false);
    }

    TrendChart(Set<Metric> visibleMetrics, boolean useLines) {
        this.visibleMetrics = visibleMetrics;
        this.filledMode = useLines ? LineSeries.FilledMode.LINES : LineSeries.FilledMode.FILLED;
    }

    public abstract LinesChartModel create(Iterable<BuildResult<CoverageStatistics>> var1, ChartModelConfiguration var2);

    void addSeriesIfAvailable(LinesDataSet dataSet, LinesChartModel model, String name, String seriesId, String color) {
        if (dataSet.containsSeries(seriesId) && this.isVisible(seriesId)) {
            LineSeries branchSeries = new LineSeries(name, color, LineSeries.StackedMode.SEPARATE_LINES, this.filledMode, dataSet.getSeries(seriesId));
            model.addSeries(new LineSeries[]{branchSeries});
        }
    }

    void addSeriesIfAvailable(LinesDataSet dataSet, LinesChartModel model, Metric metric, String color) {
        String tagName = metric.toTagName();
        if (dataSet.containsSeries(tagName) && this.isVisible(tagName)) {
            LineSeries branchSeries = new LineSeries(metric.getDisplayName(), color, LineSeries.StackedMode.SEPARATE_LINES, this.filledMode, dataSet.getSeries(tagName));
            model.addSeries(new LineSeries[]{branchSeries});
        }
    }

    private boolean isVisible(String seriesId) {
        return this.visibleMetrics.contains(Metric.fromTag((String)seriesId));
    }
}

