/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.coverage;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.coverage.Node;
import edu.hm.hafner.coverage.PackageNode;
import edu.hm.hafner.coverage.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class ModuleNode
extends Node {
    private static final long serialVersionUID = 2393265115219226404L;
    private final List<String> sources = new ArrayList<String>();

    public ModuleNode(String name) {
        super(Metric.MODULE, name);
    }

    @Override
    public ModuleNode copy() {
        ModuleNode moduleNode = new ModuleNode(this.getName());
        this.getSourceFolders().forEach(moduleNode::addSource);
        return moduleNode;
    }

    @Override
    public Set<String> getSourceFolders() {
        return new HashSet<String>(this.sources);
    }

    public void addSource(String source) {
        this.sources.add(source);
    }

    public void splitPackages() {
        List<Node> allPackages = this.getChildren().stream().filter(child -> child.getMetric().equals((Object)Metric.PACKAGE)).collect(Collectors.toList());
        allPackages.forEach(this::removeChild);
        for (Node packageNode : allPackages) {
            Object[] packageParts = StringUtils.split((String)packageNode.getName(), (String)"./\\");
            if (packageParts.length > 1) {
                PackageNode localRoot;
                ArrayUtils.reverse((Object[])packageParts);
                Optional<PackageNode> splitPackages = Arrays.stream(packageParts).map(subPackage -> this.createPackageNode((String)subPackage, packageNode.getValues())).reduce(PackageNode::appendPackage);
                Node localTail = localRoot = splitPackages.get();
                while (localTail.hasChildren()) {
                    localTail = localTail.getChildren().get(0);
                }
                localTail.addAllChildren(packageNode.getChildren());
                this.mergeSinglePackage(localRoot);
                continue;
            }
            this.mergeSinglePackage(packageNode);
        }
    }

    private void mergeSinglePackage(Node packageNode) {
        for (Node existing : this.getChildren()) {
            if (!ModuleNode.isEqual(packageNode, existing)) continue;
            this.removeChild(existing);
            Node merged = existing.merge(packageNode);
            this.addChild(merged);
            return;
        }
        this.addChild(packageNode);
    }

    private static boolean isEqual(Node packageNode, Node existing) {
        return existing.getMetric().equals((Object)packageNode.getMetric()) && existing.getName().equals(packageNode.getName());
    }

    private PackageNode createPackageNode(String subPackage, List<Value> existingValues) {
        PackageNode packageNode = new PackageNode(subPackage);
        packageNode.addAllValues(existingValues);
        return packageNode;
    }

    @Override
    public boolean isAggregation() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModuleNode that = (ModuleNode)o;
        return Objects.equals(this.sources, that.sources);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sources);
    }

    @Override
    public String toString() {
        return String.format(Locale.ENGLISH, "[%s] %s <%d> %s", new Object[]{this.getMetric(), this.getName(), this.getChildren().size(), this.getSourceFolders()});
    }
}

