/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.steps.CoverageQualityGate;
import io.jenkins.plugins.coverage.metrics.steps.CoverageRecorder;
import io.jenkins.plugins.coverage.metrics.steps.CoverageTool;
import io.jenkins.plugins.coverage.metrics.steps.Messages;
import io.jenkins.plugins.prism.SourceCodeDirectory;
import io.jenkins.plugins.prism.SourceCodeRetention;
import io.jenkins.plugins.util.AbstractExecution;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.ValidationUtilities;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CoverageStep
extends Step
implements Serializable {
    private static final long serialVersionUID = 34386077204781270L;
    private static final ValidationUtilities VALIDATION_UTILITIES = new ValidationUtilities();
    private ArrayList<CoverageTool> tools = new ArrayList();
    private ArrayList<CoverageQualityGate> qualityGates = new ArrayList();
    private String id = "";
    private String name = "";
    private boolean skipPublishingChecks = false;
    private String checksName = "";
    private CoverageRecorder.ChecksAnnotationScope checksAnnotationScope = CoverageRecorder.ChecksAnnotationScope.MODIFIED_LINES;
    private boolean ignoreParsingErrors = false;
    private boolean failOnError = false;
    private boolean enabledForFailure = false;
    private boolean skipSymbolicLinks = false;
    private String scm = "";
    private String sourceCodeEncoding = "";
    private HashSet<SourceCodeDirectory> sourceDirectories = new HashSet();
    private SourceCodeRetention sourceCodeRetention = SourceCodeRetention.LAST_BUILD;

    @DataBoundConstructor
    public CoverageStep() {
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    @DataBoundSetter
    public void setTools(List<CoverageTool> tools) {
        this.tools = new ArrayList<CoverageTool>(tools);
    }

    public List<CoverageTool> getTools() {
        return this.tools;
    }

    @DataBoundSetter
    public void setQualityGates(List<CoverageQualityGate> qualityGates) {
        this.qualityGates = new ArrayList<CoverageQualityGate>(qualityGates);
    }

    public List<CoverageQualityGate> getQualityGates() {
        return this.qualityGates;
    }

    @DataBoundSetter
    public void setId(String id) {
        VALIDATION_UTILITIES.ensureValidId(id);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @DataBoundSetter
    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @DataBoundSetter
    public void setSkipPublishingChecks(boolean skipPublishingChecks) {
        this.skipPublishingChecks = skipPublishingChecks;
    }

    public boolean isSkipPublishingChecks() {
        return this.skipPublishingChecks;
    }

    @DataBoundSetter
    public void setChecksName(String checksName) {
        this.checksName = checksName;
    }

    public String getChecksName() {
        return this.checksName;
    }

    @DataBoundSetter
    public void setChecksAnnotationScope(CoverageRecorder.ChecksAnnotationScope checksAnnotationScope) {
        this.checksAnnotationScope = checksAnnotationScope;
    }

    public CoverageRecorder.ChecksAnnotationScope getChecksAnnotationScope() {
        return this.checksAnnotationScope;
    }

    @DataBoundSetter
    public void setSkipSymbolicLinks(boolean skipSymbolicLinks) {
        this.skipSymbolicLinks = skipSymbolicLinks;
    }

    public boolean isSkipSymbolicLinks() {
        return this.skipSymbolicLinks;
    }

    @DataBoundSetter
    public void setIgnoreParsingErrors(boolean ignoreParsingErrors) {
        this.ignoreParsingErrors = ignoreParsingErrors;
    }

    public boolean isIgnoreParsingErrors() {
        return this.ignoreParsingErrors;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setEnabledForFailure(boolean enabledForFailure) {
        this.enabledForFailure = enabledForFailure;
    }

    public boolean isEnabledForFailure() {
        return this.enabledForFailure;
    }

    @DataBoundSetter
    public void setSourceCodeEncoding(String sourceCodeEncoding) {
        this.sourceCodeEncoding = sourceCodeEncoding;
    }

    public String getSourceCodeEncoding() {
        return this.sourceCodeEncoding;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<SourceCodeDirectory> sourceCodeDirectories) {
        this.sourceDirectories = new HashSet<SourceCodeDirectory>(sourceCodeDirectories);
    }

    public Set<SourceCodeDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    @DataBoundSetter
    public void setSourceCodeRetention(SourceCodeRetention sourceCodeRetention) {
        this.sourceCodeRetention = sourceCodeRetention;
    }

    public SourceCodeRetention getSourceCodeRetention() {
        return this.sourceCodeRetention;
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    static class Execution
    extends AbstractExecution<Void> {
        private static final long serialVersionUID = -2840020502160375407L;
        private static final Void UNUSED = null;
        private final CoverageStep step;

        Execution(@NonNull StepContext context, CoverageStep step) {
            super(context);
            this.step = step;
        }

        @CheckForNull
        protected Void run() throws IOException, InterruptedException {
            CoverageRecorder recorder = new CoverageRecorder();
            recorder.setTools(this.step.getTools());
            recorder.setQualityGates(this.step.getQualityGates());
            recorder.setId(this.step.getId());
            recorder.setName(this.step.getName());
            recorder.setSkipPublishingChecks(this.step.isSkipPublishingChecks());
            recorder.setChecksName(this.step.getChecksName());
            recorder.setChecksAnnotationScope(this.step.getChecksAnnotationScope());
            recorder.setIgnoreParsingErrors(this.step.isIgnoreParsingErrors());
            recorder.setFailOnError(this.step.isFailOnError());
            recorder.setEnabledForFailure(this.step.isEnabledForFailure());
            recorder.setScm(this.step.getScm());
            recorder.setSourceCodeEncoding(this.step.getSourceCodeEncoding());
            recorder.setSourceDirectories(List.copyOf(this.step.getSourceDirectories()));
            recorder.setSourceCodeRetention(this.step.getSourceCodeRetention());
            recorder.perform(this.getRun(), this.getWorkspace(), this.getTaskListener(), this.createResultHandler());
            return UNUSED;
        }
    }

    @Extension
    public static class Descriptor
    extends StepDescriptor {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();

        public String getFunctionName() {
            return "recordCoverage";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_Name();
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(FilePath.class, FlowNode.class, Run.class, TaskListener.class);
        }

        public String argumentsToString(@NonNull Map<String, Object> namedArgs) {
            String formatted = super.argumentsToString(namedArgs);
            if (formatted != null) {
                return formatted;
            }
            return namedArgs.toString();
        }

        @POST
        public ListBoxModel doFillSourceCodeRetentionItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return SourceCodeRetention.fillItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillChecksAnnotationScopeItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return CoverageRecorder.ChecksAnnotationScope.fillItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ComboBoxModel doFillSourceCodeEncodingItems() {
            if (JENKINS.hasPermission(Jenkins.READ)) {
                return VALIDATION_UTILITIES.getAllCharsets();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckSourceCodeEncoding(@AncestorInPath BuildableItem project, @QueryParameter String sourceCodeEncoding) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateCharset(sourceCodeEncoding);
        }

        @POST
        public FormValidation doCheckId(@AncestorInPath BuildableItem project, @QueryParameter String id) {
            if (!JENKINS.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return VALIDATION_UTILITIES.validateId(id);
        }
    }
}

