/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.coverage.metrics.steps;

import edu.hm.hafner.coverage.Metric;
import edu.hm.hafner.util.VisibleForTesting;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.coverage.metrics.model.Baseline;
import io.jenkins.plugins.coverage.metrics.model.ElementFormatter;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.QualityGate;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

public class CoverageQualityGate
extends QualityGate {
    private static final long serialVersionUID = -397278599489426668L;
    private static final ElementFormatter FORMATTER = new ElementFormatter();
    private final Metric metric;
    private Baseline baseline = Baseline.PROJECT;

    @DataBoundConstructor
    public CoverageQualityGate(Metric metric) {
        this(metric, 0.0);
    }

    CoverageQualityGate(Metric metric, double threshold) {
        this.setThreshold(threshold);
        this.metric = metric;
    }

    CoverageQualityGate(double threshold, Metric metric, Baseline baseline, QualityGate.QualityGateCriticality criticality) {
        this(metric, threshold);
        this.setBaseline(baseline);
        this.setCriticality(criticality);
    }

    @DataBoundSetter
    public final void setBaseline(Baseline baseline) {
        this.baseline = baseline;
    }

    public String getName() {
        return "%s - %s".formatted(FORMATTER.getDisplayName(this.getBaseline()), FORMATTER.getDisplayName(this.getMetric()));
    }

    public Metric getMetric() {
        return this.metric;
    }

    public Baseline getBaseline() {
        return this.baseline;
    }

    @Extension
    public static class Descriptor
    extends QualityGate.QualityGateDescriptor {
        private final JenkinsFacade jenkins;

        @VisibleForTesting
        Descriptor(JenkinsFacade jenkinsFacade) {
            this.jenkins = jenkinsFacade;
        }

        public Descriptor() {
            this(new JenkinsFacade());
        }

        @POST
        public ListBoxModel doFillMetricItems() {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                return FORMATTER.getMetricItems();
            }
            return new ListBoxModel();
        }

        @POST
        public ListBoxModel doFillBaselineItems() {
            if (this.jenkins.hasPermission(Jenkins.READ)) {
                return FORMATTER.getBaselineItems();
            }
            return new ListBoxModel();
        }
    }
}

